/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import java.util.Stack;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;

public final class AttributeGroupReference
extends SchemaStructure
implements ComponentReference {
    private StructuredQName qName;
    private AttributeGroupDecl target;
    private boolean dangling = false;

    public AttributeGroupReference(EnterpriseConfiguration config, StructuredQName target) {
        this.setConfiguration(config);
        this.setTargetComponentName(target);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    @Override
    public int getSymbolSpace() {
        return 805;
    }

    public void setTargetComponentName(StructuredQName target) {
        this.qName = target;
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.qName;
    }

    public AttributeWildcard getAttributeWildcard(SchemaCompiler compiler) throws MissingComponentException {
        return this.getAttributeWildcard(compiler, new Stack<AttributeGroupDecl>());
    }

    protected AttributeWildcard getAttributeWildcard(SchemaCompiler compiler, Stack<AttributeGroupDecl> stack) throws MissingComponentException {
        this.tryToResolve(compiler);
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        if (stack.contains(this.target)) {
            return null;
        }
        return this.target.getAttributeWildcard(compiler, stack);
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        AttributeGroupDecl decl = (AttributeGroupDecl)PreparedSchema.validateReference(this, compiler, false);
        if (decl == null) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        this.lookForCycles(new Stack(), compiler);
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        this.setValidationStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.UNVALIDATED) {
            boolean b = this.fixup(compiler);
            if (b) {
                this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
                this.setValidationStatus(SchemaComponent.ValidationStatus.VALIDATED);
                return true;
            }
            this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
            this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.INVALID) {
            this.setValidationStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        this.setValidationStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException {
        if (compiler.getLanguageVersion() == 11) {
            return;
        }
        try {
            if (references.contains(this)) {
                throw new SchemaException("The definition of attribute group " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " is circular");
            }
            StructuredQName fp = this.getTargetComponentName();
            if (fp == null) {
                return;
            }
            AttributeGroupDecl group = compiler.getPreparedSchema().getAttributeGroup(fp);
            if (group != null) {
                references.push(this);
                group.lookForCycles(references, compiler);
                references.pop();
            }
        }
        catch (SchemaException err) {
            this.setTargetComponentName(StandardNames.SQ_XS_INVALID_NAME);
            throw err;
        }
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (!this.dangling) {
            if (compiler != null) {
                PreparedSchema schema = compiler.getPreparedSchema();
                if (this.target == null) {
                    this.target = schema.getAttributeGroup(this.getTargetComponentName());
                }
            }
            if (this.target == null) {
                this.target = this.getConfiguration().getSuperSchema().getAttributeGroup(this.getTargetComponentName());
            }
            if (this.target == null) {
                this.dangling = true;
            }
        }
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) {
    }
}

