/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public abstract class NonPartialOverlappingSpans
extends SimpleSpans {
    public NonPartialOverlappingSpans(SimpleSpanQuery simpleSpanQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(simpleSpanQuery, context, acceptDocs, termContexts);
        this.collectPayloads = true;
        this.hasMoreSpans = this.secondSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.hasMoreSpans &= this.firstSpans.next();
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    protected boolean advance() throws IOException {
        while (this.hasMoreSpans && this.ensureSameDoc(this.firstSpans, this.secondSpans)) {
            int matchCase = this.findMatch();
            if (matchCase == 0) {
                this.doCollectPayloads();
                return true;
            }
            if (matchCase == 1) {
                this.hasMoreSpans = this.secondSpans.next();
                continue;
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
        return false;
    }

    protected abstract int findMatch();

    private void doCollectPayloads() throws IOException {
        if (this.collectPayloads) {
            Collection<byte[]> payload;
            if (this.firstSpans.isPayloadAvailable()) {
                payload = this.firstSpans.getPayload();
                this.matchPayload.addAll(payload);
            }
            if (this.secondSpans.isPayloadAvailable()) {
                payload = this.secondSpans.getPayload();
                this.matchPayload.addAll(payload);
            }
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost() + this.secondSpans.cost();
    }
}

