/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;

public abstract class Weight {
    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public abstract Query getQuery();

    public abstract float getValueForNormalization() throws IOException;

    public abstract void normalize(float var1, float var2);

    public abstract Scorer scorer(LeafReaderContext var1, Bits var2) throws IOException;

    public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        Scorer scorer = this.scorer(context, acceptDocs);
        if (scorer == null) {
            return null;
        }
        return new DefaultBulkScorer(scorer);
    }

    static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
        }

        @Override
        public boolean score(LeafCollector collector, int max) throws IOException {
            collector.setScorer(this.scorer);
            if (max == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, this.scorer);
                return false;
            }
            int doc = this.scorer.docID();
            if (doc < 0) {
                doc = this.scorer.nextDoc();
            }
            return DefaultBulkScorer.scoreRange(collector, this.scorer, doc, max);
        }

        static boolean scoreRange(LeafCollector collector, Scorer scorer, int currentDoc, int end) throws IOException {
            while (currentDoc < end) {
                collector.collect(currentDoc);
                currentDoc = scorer.nextDoc();
            }
            return currentDoc != Integer.MAX_VALUE;
        }

        static void scoreAll(LeafCollector collector, Scorer scorer) throws IOException {
            int doc;
            while ((doc = scorer.nextDoc()) != Integer.MAX_VALUE) {
                collector.collect(doc);
            }
        }
    }
}

