/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationReading;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Word {
    private String word_;
    private Collection<SegmentationReading> readings_;

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.readings_ == null ? 0 : this.readings_.hashCode());
        result2 = 31 * result2 + (this.word_ == null ? 0 : this.word_.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Word other = (Word)obj;
        if (this.readings_ == null ? other.readings_ != null : !this.readings_.equals(other.readings_)) {
            return false;
        }
        return !(this.word_ == null ? other.word_ != null : !this.word_.equals(other.word_));
    }

    public Word(String word) {
        this.word_ = word;
        this.readings_ = new HashSet<SegmentationReading>();
    }

    public int getLength() {
        return this.word_.length();
    }

    public String getWord() {
        return this.word_;
    }

    public String toString() {
        return "[" + this.word_ + " " + this.readings_ + "]";
    }

    public void add(SegmentationReading reading) {
        this.readings_.add(reading);
    }

    public Collection<SegmentationReading> getReadings() {
        return this.readings_;
    }

    public static void printStats(List<Word> words) {
        int word_length = 0;
        int very_long_words = 0;
        int max_word_length = 0;
        int max_segment_length = 0;
        int segment_length = 0;
        int num_segments = 0;
        int num_words = 0;
        int num_readings = 0;
        int words_with_many_readings = 0;
        for (Word word : words) {
            max_word_length = Math.max(max_segment_length, word.getLength());
            word_length += word.getLength();
            if (word.getLength() > 15) {
                ++very_long_words;
            }
            for (SegmentationReading reading : word.getReadings()) {
                for (String segment : reading.getSegments()) {
                    max_segment_length = Math.max(max_segment_length, segment.length());
                    ++num_segments;
                    segment_length += segment.length();
                }
                ++num_readings;
            }
            if (word.getReadings().size() > 3) {
                ++words_with_many_readings;
            }
            ++num_words;
        }
        System.err.format("Avg word length: %d/%d = %g\n", word_length, num_words, (double)word_length * 1.0 / (double)num_words);
        System.err.format("Num very long words (> 15): %d\n", very_long_words);
        System.err.format("Max word length: %d\n", max_word_length);
        System.err.format("Avg segment length: %d/%d = %g\n", segment_length, num_segments, (double)segment_length * 1.0 / (double)num_segments);
        System.err.format("Max segment length: %d\n", max_segment_length);
        System.err.format("Segments / reading: %d/%d = %g\n", num_segments, num_readings, (double)num_segments * 1.0 / (double)num_readings);
        System.err.format("Readings / word: %d/%d = %g\n", num_readings, num_words, (double)num_readings * 1.0 / (double)num_words);
        System.err.format("Words with many readings (> 3): %d\n", words_with_many_readings);
    }
}

