/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.postag.TrainingParams;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.postag.MutableTagDictionary;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ModelUtil;

public final class POSTaggerTrainerTool
extends AbstractTrainerTool<POSSample, TrainerToolParams> {
    public POSTaggerTrainerTool() {
        super(POSSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Trains a model for the part-of-speech tagger";
    }

    @Override
    public void run(String format, String[] args2) {
        POSModel model;
        POSTaggerFactory postaggerFactory;
        Map<String, Object> resources;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
        if (this.mlParams != null && !TrainerFactory.isValid(this.mlParams)) {
            throw new TerminateToolException(1, "Training parameters file '" + ((TrainerToolParams)this.params).getParams() + "' is invalid!");
        }
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("pos tagger model", modelOutFile);
        try {
            resources = TokenNameFinderTrainerTool.loadResources(((TrainerToolParams)this.params).getResources(), ((TrainerToolParams)this.params).getFeaturegen());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while loading resources", e);
        }
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((TrainerToolParams)this.params).getFeaturegen());
        try {
            postaggerFactory = POSTaggerFactory.create(((TrainerToolParams)this.params).getFactory(), featureGeneratorBytes, resources, null);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), e);
        }
        if (((TrainerToolParams)this.params).getDict() != null) {
            try {
                postaggerFactory.setTagDictionary(postaggerFactory.createTagDictionary(((TrainerToolParams)this.params).getDict()));
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while loading POS Dictionary", e);
            }
        }
        if (((TrainerToolParams)this.params).getTagDictCutoff() != null) {
            try {
                TagDictionary dict = postaggerFactory.getTagDictionary();
                if (dict == null) {
                    dict = postaggerFactory.createEmptyTagDictionary();
                    postaggerFactory.setTagDictionary(dict);
                }
                if (!(dict instanceof MutableTagDictionary)) {
                    throw new IllegalArgumentException("Can't extend a POSDictionary that does not implement MutableTagDictionary.");
                }
                POSTaggerME.populatePOSDictionary(this.sampleStream, (MutableTagDictionary)dict, ((TrainerToolParams)this.params).getTagDictCutoff());
                this.sampleStream.reset();
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while creating/extending POS Dictionary: " + e.getMessage(), e);
            }
        }
        try {
            model = POSTaggerME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, this.mlParams, postaggerFactory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("pos tagger", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

