/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.morph;

import java.util.LinkedList;
import java.util.List;
import marmot.core.Sequence;
import marmot.morph.MorphOptions;
import marmot.morph.io.SentenceReader;
import marmot.test.morph.PipelineTest;
import org.junit.Test;

public class JointTaggerLemmatizer {
    @Test
    public void smallTest() {
        MorphOptions options = new MorphOptions();
        options.setProperty("verbose", "true");
        options.setProperty("seed", "42");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "1");
        options.setProperty("penalty", "1.0");
        options.setProperty("tag-morph", "true");
        options.setProperty("lemmatize", "true");
        options.setProperty("gold-lemma", "false");
        options.setProperty("lemma-pretraining", "true");
        options.setProperty("marginalize-lemmas", "false");
        options.setProperty("lemma-tag-dependent", "true");
        options.setProperty("use-hash-feature-table", "true");
        options.setProperty("lemma-use-lemming-generator", "2");
        options.setProperty("restrict-pos-tags-to-seen-combinations", "true");
        options.setProperty("num-iterations", "10");
        options.setProperty("train-file", "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/trn.txt");
        options.setProperty("test-file", "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/tst.txt");
        List<Sequence> train_sentences = this.getSentences(options.getTrainFile(), 1000);
        List<Sequence> test_sentences = this.getSentences(options.getTestFile(), -1);
        PipelineTest.testWithOptions(options, train_sentences, test_sentences, 1.0, 1.0, 1.0, 1.0);
    }

    @Test
    public void test() {
        MorphOptions options = new MorphOptions();
        options.setProperty("verbose", "true");
        options.setProperty("seed", "42");
        options.setProperty("initial-vector-size", "10000000");
        options.setProperty("candidates-per-state", "[4, 2, 1.5, 1.25]");
        options.setProperty("prune", "true");
        options.setProperty("order", "1");
        options.setProperty("penalty", "0.0");
        options.setProperty("tag-morph", "false");
        options.setProperty("lemmatize", "false");
        options.setProperty("num-iterations", "10");
        options.setProperty("train-file", "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/trn.txt");
        options.setProperty("test-file", "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/tst.txt");
        List<Sequence> train_sentences = this.getSentences(options.getTrainFile(), 1000);
        List<Sequence> test_sentences = this.getSentences(options.getTestFile(), -1);
        PipelineTest.testWithOptions(options, train_sentences, test_sentences, 98.53, 75.22, 99.88, 96.23);
    }

    private List<Sequence> getSentences(String trainFile, int limit) {
        List<Sequence> list = new LinkedList<Sequence>();
        for (Sequence sequence : new SentenceReader(trainFile)) {
            list.add(sequence);
        }
        if (limit >= 0 && list.size() > limit) {
            list = list.subList(0, limit);
        }
        return list;
    }
}

