/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.preprocess;

import java.util.Iterator;
import marmot.tokenize.preprocess.Pair;
import marmot.tokenize.preprocess.WikiReader;

public class WikiSelector
implements Iterable<Pair> {
    private int num_sentences_;
    private boolean expand_;
    private String tokenized_file_;
    private String untokenized_file_;
    private int token_threshold_;
    private double score_threshold_;

    public WikiSelector(String untokenized_file, String tokenized_file, boolean expand, int num_sentences, int token_threshold, double score_threshold) {
        this.num_sentences_ = num_sentences;
        this.expand_ = expand;
        this.untokenized_file_ = untokenized_file;
        this.tokenized_file_ = tokenized_file;
        this.token_threshold_ = token_threshold;
        this.score_threshold_ = score_threshold;
    }

    public WikiSelector(String untokenized_file, String tokenized_file, boolean expand, int max_sentences) {
        this(untokenized_file, tokenized_file, expand, max_sentences, 5, 0.01);
    }

    @Override
    public Iterator<Pair> iterator() {
        final WikiReader reader_ = new WikiReader(this.untokenized_file_, this.tokenized_file_, this.expand_);
        return new Iterator<Pair>(){
            Pair pair_ = null;
            int num_selected_sentences_ = 0;

            @Override
            public boolean hasNext() {
                return this.next_();
            }

            private boolean next_() {
                if (this.pair_ != null) {
                    return true;
                }
                if (WikiSelector.this.num_sentences_ > 0 && this.num_selected_sentences_ >= WikiSelector.this.num_sentences_) {
                    return false;
                }
                Pair pair = reader_.next();
                int num_tokens = pair.tokenized.split("\\s+").length;
                if (num_tokens > WikiSelector.this.token_threshold_ && pair.score > WikiSelector.this.score_threshold_) {
                    ++this.num_selected_sentences_;
                    this.pair_ = pair;
                    return true;
                }
                return this.next_();
            }

            @Override
            public Pair next() {
                this.next_();
                Pair pair = this.pair_;
                this.pair_ = null;
                return pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

