/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class LiteralCompiler
extends ExpressionCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Object item;
        Generator ga = compiler.getCurrentGenerator();
        LiteralCompiler.visitAnnotation(compiler, "LiteralCompiler-item");
        LiteralCompiler.visitLineNumber(compiler, ga, expression);
        try {
            item = SequenceTool.asItem(((Literal)expression).getValue());
        }
        catch (XPathException err) {
            throw new CannotCompileException(expression, "compileItem on non-singleton");
        }
        if (item == null) {
            ga.pushNull();
            return;
        }
        if (item instanceof AtomicValue) {
            int type = ((AtomicValue)item).getItemType().getFingerprint();
            switch (type) {
                case 514: {
                    ga.push(((BooleanValue)item).getBooleanValue());
                    ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
                    return;
                }
                case 517: {
                    ga.newInstance(Type.getType(DoubleValue.class));
                    ga.dup();
                    ga.push(((DoubleValue)item).getDoubleValue());
                    ga.invokeConstructor(DoubleValue.class, Double.TYPE);
                    return;
                }
                case 516: {
                    ga.newInstance(Type.getType(FloatValue.class));
                    ga.dup();
                    ga.push(((FloatValue)item).getFloatValue());
                    ga.invokeConstructor(FloatValue.class, Float.TYPE);
                    return;
                }
                case 533: {
                    LiteralCompiler.allocateStatic(compiler, item);
                    return;
                }
                case 513: {
                    String s = item.getStringValue();
                    if (s.isEmpty()) {
                        ga.getStaticField(StringValue.class, "EMPTY_STRING", StringValue.class);
                    } else {
                        LiteralCompiler.allocateStatic(compiler, new StringValue(s));
                    }
                    return;
                }
            }
        }
        LiteralCompiler.allocateStatic(compiler, item);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        LiteralCompiler.visitAnnotation(compiler, "LiteralCompiler-Primitive");
        LiteralCompiler.visitLineNumber(compiler, ga, expression);
        Literal literal = (Literal)expression;
        if (Literal.isEmptySequence(expression)) {
            onEmpty.generate(ga);
        } else if (requiredClass == Double.TYPE) {
            ga.push(((DoubleValue)literal.getValue()).getDoubleValue());
        } else if (requiredClass == Float.TYPE) {
            ga.push(((FloatValue)literal.getValue()).getFloatValue());
        } else if (requiredClass == String.class || requiredClass == CharSequence.class) {
            GroundedValue<?> value = ((Literal)expression).getValue();
            if (value instanceof StringValue) {
                ga.push(((StringValue)value).getStringValue());
            } else {
                this.compileToItem(compiler, expression);
                ga.checkClass(StringValue.class);
                ga.invokeInstanceMethod(StringValue.class, "getStringValue", new Class[0]);
            }
        } else if (requiredClass == Long.TYPE) {
            try {
                GroundedValue<?> value = ((Literal)expression).getValue();
                ga.push(((IntegerValue)value).longValue());
            }
            catch (XPathException e) {
                throw new CannotCompileException();
            }
        } else if (requiredClass == Integer.TYPE) {
            try {
                GroundedValue<?> value = ((Literal)expression).getValue();
                ga.push(((IntegerValue)value).longValue());
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            }
            catch (XPathException e) {
                throw new CannotCompileException();
            }
        } else {
            throw new CannotCompileException();
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        LiteralCompiler.visitAnnotation(compiler, "LiteralCompiler-itr");
        LiteralCompiler.visitLineNumber(compiler, ga, expression);
        GroundedValue<?> value = ((Literal)expression).getValue();
        if (value.getLength() == 0) {
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        } else if (value instanceof Item) {
            this.compileToItem(compiler, expression);
            ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
        } else {
            ExpressionCompiler.allocateStatic(compiler, value);
            ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        }
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        LiteralCompiler.visitLineNumber(compiler, ga, expression);
        GroundedValue<?> value = ((Literal)expression).getValue();
        try {
            boolean b = ExpressionTool.effectiveBooleanValue(value.iterate());
            ga.push(b);
        }
        catch (XPathException e) {
            throw new CannotCompileException(expression);
        }
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LiteralCompiler.visitLineNumber(compiler, ga, expression);
        compiler.generateGetReceiver();
        int outVar = methodInfo.allocateLocal(SequenceReceiver.class);
        ga.storeLocal(outVar);
        GroundedValue<?> value = ((Literal)expression).getValue();
        ExpressionCompiler.allocateStatic(compiler, value);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        int seqVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(seqVar);
        LabelInfo end = methodInfo.newLabel("endLit");
        LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadLocal(seqVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(end.label());
        ga.loadLocal(outVar);
        ga.swap();
        LiteralCompiler.allocateStatic(compiler, ExplicitLocation.UNKNOWN_LOCATION);
        ga.push(524288);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
        ga.goTo(loop);
        methodInfo.placeLabel(end);
        ga.pop();
        methodInfo.releaseLocal(outVar);
        methodInfo.releaseLocal(seqVar);
    }
}

