/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;

public class TraceExprAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    public static int sequenceNr = 0;

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : super.getFeedMaker(arg);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new TraceFeed((TraceExpression)this.getExpression(), out, context);
    }

    private static class TraceFeed
    extends ItemFeed {
        InstructionInfo info;
        TraceListener listener;

        public TraceFeed(TraceExpression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            TraceExpression expr = (TraceExpression)this.getExpression();
            this.info = expr.getInstructionInfo();
            if (this.getContext().getController().isTracing()) {
                this.listener = this.getContext().getController().getTraceListener();
            }
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (this.listener != null) {
                this.listener.enter(this.info, this.getContext());
            }
            this.getResult().processItem(item);
            if (this.listener != null) {
                this.listener.leave(this.info);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.listener != null) {
                this.listener.enter(this.info, this.getContext());
            }
            return this.getResult().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            if (this.listener != null) {
                this.listener.leave(this.info);
            }
            this.getResult().endSelectedParentNode(locationId);
        }
    }
}

