/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class FloatToBooleanCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "FloatToBooleanConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            this.compileToPrimitive(compiler, expression, Float.TYPE, new OnEmpty.UnwindAndJump(empty));
            ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            this.compileToPrimitive(compiler, expression, Float.TYPE, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "FloatToBooleanConverter-Primitive");
        if (allowsEmpty && !(onEmpty instanceof OnEmpty.UnwindAndJump)) {
            throw new IllegalArgumentException();
        }
        compiler.compileToPrimitive(base, Float.TYPE, onEmpty);
        LabelInfo checkNaN = methodInfo.newLabel("checkForNaN");
        LabelInfo isTrue = methodInfo.newLabel("isTrue_cast");
        LabelInfo end = methodInfo.newLabel("castEnd");
        ga.dup();
        ga.push(0.0f);
        ga.ifCmp(Type.FLOAT_TYPE, 154, checkNaN.label());
        ga.pop();
        ga.push(false);
        ga.goTo(end);
        methodInfo.placeLabel(checkNaN);
        ga.invokeStaticMethod(Float.class, "isNaN", Float.TYPE);
        ga.ifFalse(isTrue);
        ga.push(false);
        ga.goTo(end);
        methodInfo.placeLabel(isTrue);
        ga.push(true);
        methodInfo.placeLabel(end);
    }
}

