/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

public class FilteringFeed
extends ItemFeed {
    private Filter filter;
    private int position;
    private Stack<Boolean> matchStack = new Stack();
    private boolean terminated;

    public FilteringFeed(Feed nextFeed, XPathContext context, Filter filter) {
        super(nextFeed, context);
        this.filter = filter;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.getResult().open(terminator);
        this.position = 0;
        this.terminated = false;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.terminated) {
            int match;
            this.matchStack.push((match = this.filter.matches(node, ++this.position)) == 1);
            if (match == 1) {
                return this.getResult().startSelectedParentNode(node, locationId);
            }
            if (match == 2 && this.getTerminator() != null) {
                this.getResult().close();
                this.terminated = true;
                this.getTerminator().terminate();
            }
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.terminated && this.matchStack.pop().booleanValue()) {
            this.getResult().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.terminated && !this.hasFailed()) {
            try {
                int match = this.filter.matches(item, ++this.position);
                if (match == 1) {
                    this.getResult().processItem(item);
                } else if (match == 2 && this.getTerminator() != null) {
                    this.getResult().close();
                    this.terminated = true;
                    this.getTerminator().terminate();
                }
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.terminated && !this.hasFailed()) {
            this.getResult().close();
        }
    }

    @Override
    public SequenceReceiver getReceiver() {
        Receiver next = this.getResult().getReceiver();
        return new ProxyReceiver(next){

            @Override
            public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
                FilteringFeed.this.processItem(item);
            }
        };
    }

    public static class OpaqueFilter
    implements Filter {
        @Override
        public int matches(Item item, int position) throws XPathException {
            return 2;
        }
    }

    public static class TransparentFilter
    implements Filter {
        @Override
        public int matches(Item item, int position) throws XPathException {
            return 1;
        }
    }

    public static interface Filter {
        public static final int SKIP = 0;
        public static final int MATCHES = 1;
        public static final int DONE = 2;

        public int matches(Item var1, int var2) throws XPathException;
    }
}

