/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;

public class RootExpressionCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        RootExpressionCompiler.visitLineNumber(compiler, ga, expression);
        RootExpressionCompiler.visitAnnotation(compiler, "RootExpressionCompiler");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
        LabelInfo end = methodInfo.newLabel("endRoot");
        LabelInfo notInstanceLab = methodInfo.newLabel("notInstanceLab");
        if (((RootExpression)expression).isContextPossiblyUndefined()) {
            LabelInfo notNull = methodInfo.newLabel("contextNotNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            compiler.generateDynamicError("Finding root of tree: the context item is absent", "XPDY0002", expression.getLocation(), false);
            methodInfo.placeLabel(notNull);
        }
        ga.dup();
        ga.ifNotInstance(NodeInfo.class, notInstanceLab);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getRoot", new Class[0]);
        ga.dup();
        ga.invokeInstanceMethod(NodeInfo.class, "getNodeKind", new Class[0]);
        ga.push(9);
        ga.ifICmp(153, end.label());
        compiler.generateDynamicError("The root of the tree containing the context item is not a document node", "XPDY0050", expression.getLocation(), false);
        methodInfo.placeLabel(notInstanceLab);
        compiler.generateDynamicError("Finding root of tree: the context item is not a node", "XPTY0020", expression.getLocation(), true);
        methodInfo.placeLabel(end);
    }
}

