/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import java.io.IOException;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDInclude
extends AnnotationParent {
    private PreparedSchema includedSchema;

    @Override
    public void prepareAttributes() throws SchemaException {
        Source source;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue("", "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            return;
        }
        SchemaCompiler manager = this.getXSDSchema().getSchemaCompiler();
        try {
            source = SchemaReader.getSource(this.getBaseURI(), schemaLocation, manager.getPipelineConfiguration(), null);
        }
        catch (SchemaException e) {
            e.setLocator(this);
            this.error(e);
            this.includedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), "");
            return;
        }
        if (source != null) {
            XSDSchema existing = manager.getExistingSchemaDocument(source.getSystemId(), this.getXSDSchema().getTargetNamespace());
            if (existing != null) {
                this.includedSchema = existing.getSchema();
                return;
            }
            if (manager.isBeingRead(source.getSystemId())) {
                this.warning("Module " + source.getSystemId() + " includes itself recursively");
                return;
            }
            try {
                PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
                SchemaCompiler compiler = this.getSchemaNodeFactory().getSchemaCompiler();
                SchemaDocument inc = SchemaReader.read(source, compiler, pipe, this);
                XSDSchema includedXSDSchema = inc.getXSDSchema();
                includedXSDSchema.setReferrer(this);
                this.includedSchema = includedXSDSchema.getSchema();
                manager.markAsRead(source.getSystemId(), includedXSDSchema);
            }
            catch (SchemaException e) {
                Throwable cause = e.getException();
                if (cause instanceof IOException) {
                    this.warning("Included schema document " + schemaLocation + " cannot be located: " + cause.getClass().getName() + " (" + cause.getMessage() + ")");
                    this.includedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), "");
                }
                this.error("Failed to process included schema document " + schemaLocation);
                throw e;
            }
        }
    }

    public PreparedSchema getIncludedSchema() {
        return this.includedSchema;
    }
}

