/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class CurrentMergeGroupStreamer
extends TransmissionAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        return AnchorPattern.getInstance();
    }

    @Override
    public Trigger makeTransmissionFlow(WatchManager watchManager, Expression exp, Feed out, XPathContext context) throws XPathException {
        AnchorPattern selection = AnchorPattern.getInstance();
        return new Trigger(selection, this.makeItemFeed(watchManager, out, context), context);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        if (Streamability.getPosture(this.getExpression()) == Posture.GROUNDED) {
            return new GroupingFeed(out, context);
        }
        return out;
    }

    private class GroupingFeed
    extends ItemFeed {
        private List<Item> group;

        public GroupingFeed(Feed out, XPathContext context) {
            super(out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            this.group = new ArrayList<Item>();
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            this.group.add(item);
        }

        @Override
        public void close() throws XPathException {
            this.getResult().open(this.getTerminator());
            this.getResult().processItem(this.group.get(0));
            this.getResult().close();
        }
    }
}

