/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import marmot.morph.mapper.latin.LdtMorphTag;

public class ProielLdtMorphTagMapper {
    public LdtMorphTag convert(String pos, String feats) {
        LdtMorphTag tag = new LdtMorphTag();
        this.setPos(tag, pos);
        this.setFeats(tag, feats);
        return tag;
    }

    public void setFeats(LdtMorphTag tag, String feats_string) {
        String[] feats;
        for (String feat : feats = feats_string.split("\\|")) {
            this.setFeat(tag, feat);
        }
    }

    private void setFeat(LdtMorphTag tag, String feat) {
        switch (feat = feat.toLowerCase()) {
            case "numbs": {
                tag.number_ = LdtMorphTag.Number.s;
                break;
            }
            case "numbp": {
                tag.number_ = LdtMorphTag.Number.p;
                break;
            }
            case "gendf": {
                tag.gender_ = LdtMorphTag.Gender.f;
                break;
            }
            case "gendn": {
                tag.gender_ = LdtMorphTag.Gender.n;
                break;
            }
            case "gendm": {
                tag.gender_ = LdtMorphTag.Gender.m;
                break;
            }
            case "gendp": 
            case "gendq": 
            case "gendo": 
            case "gendr": {
                break;
            }
            case "casea": {
                tag.case_ = LdtMorphTag.Case.a;
                break;
            }
            case "casen": {
                tag.case_ = LdtMorphTag.Case.n;
                break;
            }
            case "caseg": {
                tag.case_ = LdtMorphTag.Case.g;
                break;
            }
            case "cased": {
                tag.case_ = LdtMorphTag.Case.d;
                break;
            }
            case "caseb": {
                tag.case_ = LdtMorphTag.Case.b;
                break;
            }
            case "casel": {
                tag.case_ = LdtMorphTag.Case.l;
                break;
            }
            case "casev": {
                tag.case_ = LdtMorphTag.Case.v;
                break;
            }
            case "infln": 
            case "infli": {
                break;
            }
            case "pers1": {
                tag.person_ = LdtMorphTag.Person.first;
                break;
            }
            case "pers2": {
                tag.person_ = LdtMorphTag.Person.second;
                break;
            }
            case "pers3": {
                tag.person_ = LdtMorphTag.Person.third;
                break;
            }
            case "tensr": {
                tag.tense_ = LdtMorphTag.Tense.r;
                break;
            }
            case "tensl": {
                tag.tense_ = LdtMorphTag.Tense.l;
                break;
            }
            case "tenst": {
                tag.tense_ = LdtMorphTag.Tense.t;
                break;
            }
            case "tensp": {
                tag.tense_ = LdtMorphTag.Tense.p;
                break;
            }
            case "tensi": {
                tag.tense_ = LdtMorphTag.Tense.i;
                break;
            }
            case "tensf": {
                tag.tense_ = LdtMorphTag.Tense.f;
                break;
            }
            case "moodi": {
                tag.mood_ = LdtMorphTag.Mood.i;
                break;
            }
            case "moods": {
                tag.mood_ = LdtMorphTag.Mood.s;
                break;
            }
            case "moodn": {
                tag.mood_ = LdtMorphTag.Mood.n;
                break;
            }
            case "moodm": {
                tag.mood_ = LdtMorphTag.Mood.m;
                break;
            }
            case "moodp": {
                tag.pos_ = LdtMorphTag.Pos.t;
                tag.mood_ = LdtMorphTag.Mood.p;
                break;
            }
            case "moodd": {
                tag.mood_ = LdtMorphTag.Mood.d;
                break;
            }
            case "moodg": {
                tag.mood_ = LdtMorphTag.Mood.g;
                break;
            }
            case "moodu": {
                tag.mood_ = LdtMorphTag.Mood.u;
                break;
            }
            case "voica": {
                tag.voice_ = LdtMorphTag.Voice.a;
                break;
            }
            case "voicp": {
                tag.voice_ = LdtMorphTag.Voice.p;
                break;
            }
            case "degrp": {
                break;
            }
            case "degrs": {
                tag.degree_ = LdtMorphTag.Degree.s;
                break;
            }
            case "degrc": {
                tag.degree_ = LdtMorphTag.Degree.c;
                break;
            }
            default: {
                throw new RuntimeException("Unknown feat: " + feat);
            }
        }
    }

    public void setPos(LdtMorphTag tag, String pos) {
        assert (pos.length() == 2);
        char c = Character.toLowerCase(pos.charAt(0));
        switch (c) {
            case 'n': {
                tag.pos_ = LdtMorphTag.Pos.n;
                break;
            }
            case 'v': {
                tag.pos_ = LdtMorphTag.Pos.v;
                break;
            }
            case 'd': {
                tag.pos_ = LdtMorphTag.Pos.d;
                break;
            }
            case 'c': 
            case 'g': {
                tag.pos_ = LdtMorphTag.Pos.c;
                break;
            }
            case 'p': {
                tag.pos_ = LdtMorphTag.Pos.p;
                break;
            }
            case 'r': {
                tag.pos_ = LdtMorphTag.Pos.r;
                break;
            }
            case 'm': {
                tag.pos_ = LdtMorphTag.Pos.m;
                break;
            }
            case 'a': {
                tag.pos_ = LdtMorphTag.Pos.a;
                break;
            }
            case 'i': {
                tag.pos_ = LdtMorphTag.Pos.i;
                break;
            }
            case 'f': {
                tag.pos_ = LdtMorphTag.Pos.Undef;
                break;
            }
            default: {
                throw new RuntimeException("Unknown tag character: " + c);
            }
        }
    }
}

