/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import marmot.util.CollectableDouble;
import marmot.util.CollectableSet;
import marmot.util.StringUtils;
import marmot.util.Trie;
import org.junit.Assert;
import org.junit.Test;

public class TrieTest {
    @Test
    public void testSimpleDoubleInsertion() {
        Trie<CollectableDouble> trie = new Trie<CollectableDouble>();
        trie.addWord("a", new CollectableDouble(10.0));
        Assert.assertFalse((boolean)trie.isTerminal());
        Map children2 = trie.getChildren();
        Assert.assertNotSame(null, children2);
        Assert.assertEquals((long)1L, (long)children2.size());
        Trie child = children2.get(Character.valueOf('a'));
        Assert.assertNotSame(null, child);
        Assert.assertEquals((double)10.0, (double)((CollectableDouble)child.getContent()).getValue(), (double)0.001);
        Assert.assertTrue((boolean)child.isTerminal());
        trie.addWord("a", new CollectableDouble(20.0));
        Assert.assertEquals((double)30.0, (double)((CollectableDouble)child.getContent()).getValue(), (double)0.001);
        trie.addWord("ab", new CollectableDouble(20.0));
        Assert.assertEquals((double)30.0, (double)((CollectableDouble)child.getContent()).getValue(), (double)0.001);
    }

    @Test
    public void testSimpleWord() {
        Trie<CollectableDouble> trie = new Trie<CollectableDouble>();
        trie.addWord("ab", new CollectableDouble(10.0));
        Assert.assertFalse((boolean)trie.isTerminal());
        Map children2 = trie.getChildren();
        Assert.assertNotSame(null, children2);
        Assert.assertEquals((long)1L, (long)children2.size());
        Trie child = children2.get(Character.valueOf('a'));
        Assert.assertNotSame(null, child);
        Assert.assertEquals(null, child.getContent());
        Assert.assertFalse((boolean)child.isTerminal());
        children2 = child.getChildren();
        Assert.assertNotSame(null, children2);
        Assert.assertEquals((long)1L, (long)children2.size());
        child = children2.get(Character.valueOf('b'));
        Assert.assertNotSame(null, child);
        Assert.assertEquals((double)10.0, (double)((CollectableDouble)child.getContent()).getValue(), (double)0.001);
        Assert.assertTrue((boolean)child.isTerminal());
    }

    @Test
    public void toyTestPropagation() {
        Trie<CollectableSet> trie = new Trie<CollectableSet>();
        trie.addWord("abc", new CollectableSet("A"));
        trie.propagateContent(100);
        Map children2 = trie.getChildren();
        Assert.assertTrue((null == children2 ? 1 : 0) != 0);
        Assert.assertEquals(Collections.singleton("A"), ((CollectableSet)trie.getContent()).getValue());
        trie = new Trie();
        trie.addWord("abc", new CollectableSet("A"));
        trie.addWord("a", new CollectableSet("B"));
        trie.propagateContent(100);
        children2 = trie.getChildren();
        Assert.assertTrue((null != children2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)children2.size());
        Trie child = children2.get(Character.valueOf('a'));
        Assert.assertTrue((null != child ? 1 : 0) != 0);
        Assert.assertTrue((null == child.getContent() ? 1 : 0) != 0);
        HashSet<String> expected_set = new HashSet<String>();
        expected_set.add("A");
        expected_set.add("B");
        Assert.assertEquals(expected_set, ((CollectableSet)trie.getContent()).getValue());
        children2 = child.getChildren();
        Assert.assertTrue((null != children2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)children2.size());
        child = children2.get(Character.valueOf('b'));
        children2 = child.getChildren();
        Assert.assertTrue((null == children2 ? 1 : 0) != 0);
        Assert.assertEquals(Collections.singleton("A"), ((CollectableSet)child.getContent()).getValue());
    }

    public String reverse(String s2) {
        return StringUtils.reverse(s2);
    }

    @Test
    public void testPropagation() {
        Trie<CollectableSet> trie = new Trie<CollectableSet>();
        HashSet<String> expected_set = new HashSet<String>();
        trie.addWord(this.reverse("booking"), new CollectableSet("V"));
        trie.addWord(this.reverse("booking"), new CollectableSet("N"));
        trie.addWord(this.reverse("sleeping"), new CollectableSet("V"));
        trie.addWord(this.reverse("reads"), new CollectableSet("V"));
        trie.addWord(this.reverse("knows"), new CollectableSet("V"));
        trie.propagateContent(100);
        CollectableSet cset = (CollectableSet)trie.getContent(this.reverse("ing"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.add("V");
        expected_set.add("N");
        Assert.assertEquals(expected_set, cset.getValue());
        cset = (CollectableSet)trie.getContent(this.reverse("ping"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.clear();
        expected_set.add("V");
        Assert.assertEquals(expected_set, cset.getValue());
        cset = (CollectableSet)trie.getContent(this.reverse("s"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.clear();
        expected_set.add("V");
        Assert.assertEquals(expected_set, cset.getValue());
        cset = (CollectableSet)trie.getContent(this.reverse("viking"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.clear();
        expected_set.add("V");
        expected_set.add("N");
        Assert.assertEquals(expected_set, cset.getValue());
        cset = (CollectableSet)trie.getContent(this.reverse("weeping"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.clear();
        expected_set.add("V");
        Assert.assertEquals(expected_set, cset.getValue());
        cset = (CollectableSet)trie.getContent(this.reverse("geese"));
        Assert.assertTrue((null != cset ? 1 : 0) != 0);
        expected_set.clear();
        expected_set.add("V");
        expected_set.add("N");
        Assert.assertEquals(expected_set, cset.getValue());
    }
}

