/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.ids_mannheim.korap.index.AbstractDocument;
import de.ids_mannheim.korap.index.PositionsToOffset;
import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.response.MetaField;
import de.ids_mannheim.korap.response.SearchContext;
import de.ids_mannheim.korap.response.match.HighlightCombinator;
import de.ids_mannheim.korap.response.match.HighlightCombinatorElement;
import de.ids_mannheim.korap.response.match.MatchIdentifier;
import de.ids_mannheim.korap.response.match.PosIdentifier;
import de.ids_mannheim.korap.response.match.Relation;
import de.ids_mannheim.korap.util.KrillByte;
import de.ids_mannheim.korap.util.KrillProperties;
import de.ids_mannheim.korap.util.KrillString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Match
extends AbstractDocument {
    private static final Logger log = LoggerFactory.getLogger(Match.class);
    private static final int PB_MARKER = -99999;
    private static final int ALL_MARKER = -99998;
    private static final int CONTEXT = -99997;
    public static final boolean DEBUG = false;
    ObjectMapper mapper = new ObjectMapper();
    @JsonIgnore
    public SearchContext context;
    @JsonIgnore
    public int startPos;
    @JsonIgnore
    public int endPos = -1;
    @JsonIgnore
    private int innerMatchStartPos;
    @JsonIgnore
    private int innerMatchEndPos = -1;
    @JsonIgnore
    public int potentialStartPosChar = -1;
    @JsonIgnore
    public int potentialEndPosChar = -1;
    @JsonIgnore
    public boolean startCutted = false;
    @JsonIgnore
    public boolean endCutted = false;
    private String version;
    @JsonIgnore
    public int localDocID = -1;
    private HashMap<Integer, String> annotationNumber = new HashMap(16);
    private HashMap<Integer, Relation> relationNumber = new HashMap(16);
    private HashMap<Integer, String> identifierNumber = new HashMap(16);
    int annotationNumberCounter = 256;
    int relationNumberCounter = 2048;
    int identifierNumberCounter = -2;
    private int startPage = -1;
    private int endPage = -1;
    private String tempSnippet;
    private String snippetHTML;
    private String snippetBrackets;
    private String identifier;
    private String mirrorIdentifier;
    private ObjectNode snippetTokens;
    private HighlightCombinator snippetArray;
    public boolean hasSnippet = false;
    public boolean hasTokens = false;
    @JsonIgnore
    public boolean startMore = true;
    @JsonIgnore
    public boolean endMore = true;
    private ArrayList<Highlight> highlight;
    private LinkedList<int[]> span;
    private PositionsToOffset positionsToOffset;
    private boolean processed = false;

    public Match(int maxTokenMatchSize, PositionsToOffset pto, int localDocID, int startPos, int endPos) {
        this.positionsToOffset = pto;
        this.localDocID = localDocID;
        this.setStartPos(maxTokenMatchSize, startPos);
        this.setEndPos(maxTokenMatchSize, endPos);
    }

    public Match() {
    }

    public Match(int maxTokenMatchSize, String idString, boolean includeHighlights) {
        MatchIdentifier id = new MatchIdentifier(idString);
        if (id.getStartPos() > -1) {
            this.mirrorIdentifier = id.toString();
            if (id.getTextSigle() != null) {
                this.addString("textSigle", id.getTextSigle());
            }
            this.addString("corpusID", id.getCorpusID());
            this.addString("ID", id.getDocID());
            this.setStartPos(maxTokenMatchSize, id.getStartPos());
            this.setEndPos(maxTokenMatchSize, id.getEndPos());
            if (includeHighlights) {
                for (int[] pos : id.getPos()) {
                    if (pos[0] < id.getStartPos() || pos[1] > id.getEndPos()) continue;
                    this.addHighlight(pos[0], pos[1], pos[2]);
                }
            }
        }
    }

    public void addPayload(List<byte[]> payload) {
        Collections.reverse(payload);
        try {
            ByteBuffer bb = ByteBuffer.allocate(24);
            for (byte[] b : payload) {
                if (b[0] == 0) {
                    bb.put(b);
                    bb.position(1);
                    int start = bb.getInt();
                    int end = bb.getInt();
                    byte number = bb.get();
                    if (KrillByte.unsignedByte(number) <= 128 && start >= this.getStartPos() && end <= this.getEndPos()) {
                        this.addHighlight(start, end - 1, number);
                    }
                } else if (b[0] == 64) {
                    bb.put(b);
                    bb.position(1);
                    if (this.potentialStartPosChar == -1) {
                        this.potentialStartPosChar = bb.getInt(1);
                    } else if (bb.getInt(0) < this.potentialStartPosChar) {
                        this.potentialStartPosChar = bb.getInt(1);
                    }
                    if (bb.getInt(4) > this.potentialEndPosChar && !this.endCutted) {
                        this.potentialEndPosChar = bb.getInt(5);
                    }
                }
                bb.clear();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void addHighlight(int start, int end) {
        this.addHighlight(new Highlight(start, end, 0));
    }

    public void addHighlight(int start, int end, byte number) {
        this.addHighlight(new Highlight(start, end, number));
    }

    public void addHighlight(int start, int end, short number) {
        this.addHighlight(new Highlight(start, end, number));
    }

    public void addHighlight(int start, int end, int number) {
        this.addHighlight(new Highlight(start, end, number));
    }

    public void addHighlight(Highlight hl) {
        if (this.highlight == null) {
            this.highlight = new ArrayList(16);
        }
        this._reset();
        this.highlight.add(hl);
    }

    public void addAnnotation(int start, int end, String annotation) {
        this.addHighlight(new Highlight(start, end, annotation));
    }

    public void addRelation(int srcStart, int srcEnd, int targetStart, int targetEnd, String annotation) {
        if (srcEnd == -1) {
            this.addHighlight(new Highlight(srcStart, srcStart, annotation, targetStart, targetEnd));
        } else {
            this.addHighlight(new Highlight(srcStart, srcEnd, annotation, targetStart, targetEnd));
        }
        int id = this.identifierNumberCounter--;
        if (targetEnd == -1 || targetStart == targetEnd) {
            this.addHighlight(new Highlight(targetStart, targetStart, id));
            this.identifierNumber.put(id, String.valueOf(targetStart));
        } else {
            this.addHighlight(new Highlight(targetStart, targetEnd, id));
            this.identifierNumber.put(id, targetStart + "-" + targetEnd);
        }
    }

    public void addPagebreak(int start, int pagenumber) {
        this.addHighlight(new Highlight(start, pagenumber));
    }

    public void addMarker(int start, String data) {
        this.addHighlight(new Highlight(start, data));
    }

    @JsonProperty(value="docID")
    public String getDocID() {
        return super.getID();
    }

    @JsonIgnore
    public int getStartPage() {
        return this.startPage;
    }

    @JsonIgnore
    public int getEndPage() {
        return this.endPage;
    }

    @JsonIgnore
    public int getStartPos() {
        return this.startPos;
    }

    @JsonIgnore
    public int getStartPos(int number) {
        if (number > 256 || this.highlight == null) {
            return -1;
        }
        for (Highlight h : this.highlight) {
            if (h.number != number || h.end == -99999 || h.end == -99998) continue;
            return h.start;
        }
        return -1;
    }

    @JsonIgnore
    public void setStartPos(int maxTokenMatchSize, int pos) {
        this.startPos = pos;
        if (this.endPos != -1 && this.endPos - pos > maxTokenMatchSize) {
            this.endPos = pos + maxTokenMatchSize;
            this.endCutted = true;
        }
    }

    @JsonIgnore
    public int getEndPos() {
        return this.endPos;
    }

    @JsonIgnore
    public int getEndPos(int number) {
        if (number > 256 || this.highlight == null) {
            return -1;
        }
        for (Highlight h : this.highlight) {
            if (h.number != number || h.end == -99999) continue;
            return h.end + 1;
        }
        return -1;
    }

    @JsonIgnore
    public void setEndPos(int maxTokenMatchSize, int pos) {
        if (this.startPos != -1 && pos - this.startPos > maxTokenMatchSize) {
            pos = this.startPos + maxTokenMatchSize;
            this.endCutted = true;
        }
        this.endPos = pos;
    }

    @JsonIgnore
    public int getLocalDocID() {
        return this.localDocID;
    }

    @JsonIgnore
    public void setLocalDocID(int id) {
        this.localDocID = id;
    }

    @JsonIgnore
    public PositionsToOffset getPositionsToOffset() {
        return this.positionsToOffset;
    }

    @JsonIgnore
    public void setPositionsToOffset(PositionsToOffset pto) {
        this.positionsToOffset = pto;
    }

    @Override
    @JsonProperty(value="matchID")
    public String getID() {
        if (this.mirrorIdentifier != null) {
            return this.mirrorIdentifier;
        }
        if (this.identifier != null) {
            return this.identifier;
        }
        if (this.localDocID == -1) {
            return null;
        }
        MatchIdentifier id = this.getMatchIdentifier();
        if (this.getTextSigle() != null) {
            id.setTextSigle(this.getTextSigle());
        } else {
            id.setCorpusID(this.getCorpusID());
            id.setDocID(this.getDocID());
        }
        this.identifier = id.toString();
        return this.identifier;
    }

    @JsonIgnore
    public MatchIdentifier getMatchIdentifier() {
        MatchIdentifier id = new MatchIdentifier();
        id.setStartPos(this.startPos);
        id.setEndPos(this.endPos);
        if (this.highlight != null) {
            for (Highlight h : this.highlight) {
                if (h.number >= 256 || h.end == -99999 || h.end == -99998) continue;
                id.addPos(h.start, h.end, h.number);
            }
        }
        return id;
    }

    @JsonIgnore
    public String getPosID(int pos) {
        return this.getPosID(pos, -1);
    }

    @JsonIgnore
    public String getPosID(String pos) {
        if (pos == null) {
            return "";
        }
        String[] startEnd = pos.split("-");
        if (startEnd.length == 2) {
            return this.getPosID(Integer.parseInt(startEnd[0]), Integer.parseInt(startEnd[1]));
        }
        return this.getPosID(Integer.parseInt(startEnd[0]), -1);
    }

    @JsonIgnore
    public String getPosID(int start, int end) {
        if (this.identifier != null) {
            return this.identifier;
        }
        if (this.localDocID == -1) {
            return null;
        }
        PosIdentifier id = new PosIdentifier();
        id.setCorpusID(this.getCorpusID());
        id.setDocID(this.getDocID());
        id.setTextSigle(this.getTextSigle());
        id.setStart(start);
        id.setEnd(end);
        return id.toString();
    }

    public Match setContext(SearchContext context) {
        this.context = context;
        return this;
    }

    @JsonIgnore
    public SearchContext getContext() {
        if (this.context == null) {
            this.context = new SearchContext();
        }
        return this.context;
    }

    @JsonIgnore
    public int getLength() {
        return this.getEndPos() - this.getStartPos();
    }

    public List<int[]> retrieveMarkers(String marker) {
        if (this.positionsToOffset != null) {
            return this.retrieveMarkers(this.positionsToOffset.getLeafReader(), null, "tokens", marker);
        }
        return null;
    }

    public List<int[]> retrieveMarkers(LeafReaderContext atomic, Bits bitset, String field, String marker) {
        ArrayList<int[]> pagebreaks = new ArrayList<int[]>(24);
        int charOffset = 0;
        int pagenumber = 0;
        int start = 0;
        int minStartPos = this.getStartPos() - KrillProperties.maxTokenContextSize;
        int maxEndPos = this.getEndPos() + KrillProperties.maxTokenContextSize;
        try {
            String annoStr;
            byte[] anno;
            int bytelength;
            ByteBuffer bb = ByteBuffer.allocate(256);
            byte[] b = null;
            SpanTermQuery stq = new SpanTermQuery(new Term(field, marker));
            Spans markerSpans = stq.getSpans(atomic, bitset, new HashMap<Term, TermContext>());
            while (markerSpans.next()) {
                if (markerSpans.doc() != this.localDocID) {
                    if (markerSpans.doc() >= this.localDocID) break;
                    markerSpans.skipTo(this.localDocID);
                    if (markerSpans.doc() == this.localDocID) continue;
                    break;
                }
                if (markerSpans.start() < minStartPos) {
                    b = markerSpans.getPayload().iterator().next();
                    start = markerSpans.start();
                    continue;
                }
                if (b != null) {
                    bb.rewind();
                    bb.put(b);
                    bb.rewind();
                    pagenumber = bb.getInt();
                    charOffset = bb.getInt();
                    if (pagenumber != 0) {
                        pagebreaks.add(new int[]{charOffset, pagenumber});
                        if (start >= minStartPos) {
                            this.addPagebreak(charOffset, pagenumber);
                        }
                    } else {
                        bytelength = bb.getInt();
                        anno = new byte[bytelength];
                        bb.get(anno, 0, bytelength);
                        annoStr = new String(anno, StandardCharsets.UTF_8);
                        this.addMarker(charOffset, annoStr);
                    }
                    b = null;
                }
                if (markerSpans.start() > maxEndPos) break;
                b = markerSpans.getPayload().iterator().next();
                bb.rewind();
                bb.put(b);
                bb.rewind();
                pagenumber = bb.getInt();
                charOffset = bb.getInt();
                if (pagenumber != 0) {
                    pagebreaks.add(new int[]{charOffset, pagenumber});
                    if (start >= minStartPos) {
                        this.addPagebreak(charOffset, pagenumber);
                    }
                } else {
                    bytelength = bb.getInt();
                    anno = new byte[bytelength];
                    bb.get(anno);
                    annoStr = new String(anno, StandardCharsets.UTF_8);
                    this.addMarker(charOffset, annoStr);
                }
                b = null;
            }
            if (b != null) {
                bb.rewind();
                bb.put(b);
                bb.rewind();
                pagenumber = bb.getInt();
                charOffset = bb.getInt();
                if (pagenumber != 0) {
                    pagebreaks.add(new int[]{charOffset, pagenumber});
                    if (start >= minStartPos) {
                        this.addPagebreak(charOffset, pagenumber);
                    }
                } else {
                    bytelength = bb.getInt();
                    anno = new byte[bytelength];
                    bb.get(anno);
                    annoStr = new String(anno, StandardCharsets.UTF_8);
                    this.addMarker(charOffset, annoStr);
                }
                b = null;
            }
        }
        catch (Exception e) {
            log.warn("Some problems with ByteBuffer: {}", (Object)e.getMessage());
        }
        if (pagebreaks.size() > 0) {
            int i;
            for (i = 0; i < pagebreaks.size() && ((int[])pagebreaks.get(i))[0] <= this.getStartPos(); ++i) {
                this.startPage = ((int[])pagebreaks.get(i))[1];
            }
            while (i < pagebreaks.size() && ((int[])pagebreaks.get(i))[0] < this.getEndPos()) {
                this.endPage = ((int[])pagebreaks.get(i))[1];
                ++i;
            }
        }
        return pagebreaks;
    }

    public void expandContextToSpan(String element) {
        int[] spanContext = new int[]{0, 0, 0, 0};
        if (this.positionsToOffset != null) {
            spanContext = this.expandContextToSpan(this.positionsToOffset.getLeafReader(), null, "tokens", element);
        }
        if (spanContext[0] >= 0 && spanContext[0] < spanContext[1]) {
            int maxExpansionSize = KrillProperties.maxTokenMatchSize;
            if (KrillProperties.matchExpansionIncludeContextSize) {
                maxExpansionSize += KrillProperties.maxTokenContextSize;
            }
            boolean cutExpansion = false;
            if (spanContext[1] - spanContext[0] > maxExpansionSize) {
                int realRightLength;
                cutExpansion = true;
                int contextLength = maxExpansionSize - this.getLength();
                int halfContext = contextLength / 2;
                int realLeftLength = this.getStartPos() - spanContext[0];
                if (realLeftLength > halfContext) {
                    this.startCutted = true;
                    spanContext[0] = this.getStartPos() - halfContext;
                }
                if ((realRightLength = spanContext[1] - this.getEndPos()) > halfContext) {
                    this.endCutted = true;
                    spanContext[1] = this.getEndPos() + halfContext;
                }
            }
            this.setStartPos(maxExpansionSize, spanContext[0]);
            this.setEndPos(maxExpansionSize, spanContext[1]);
            if (cutExpansion) {
                this.positionsToOffset.add(this.localDocID, this.startPos);
                this.positionsToOffset.add(this.localDocID, this.endPos);
                int start = this.positionsToOffset.start(this.localDocID, this.startPos);
                int end = this.positionsToOffset.start(this.localDocID, this.endPos) - 1;
                spanContext[2] = start;
                spanContext[3] = end;
            }
            this.potentialStartPosChar = spanContext[2];
            this.potentialEndPosChar = spanContext[3];
            this.startMore = false;
            this.endMore = false;
            this.positionsToOffset.clear();
        } else {
            this.addMessage(651, "Unable to extend context", new String[0]);
        }
    }

    public int[] expandContextToSpan(LeafReaderContext atomic, Bits bitset, String field, String element) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(24);
            SpanElementQuery cquery = new SpanElementQuery(field, element);
            Spans contextSpans = cquery.getSpans(atomic, bitset, new HashMap<Term, TermContext>());
            int newStart = -1;
            int newEnd = -1;
            int newStartChar = -1;
            int newEndChar = -1;
            block6: while (contextSpans.next()) {
                if (contextSpans.doc() != this.localDocID) {
                    contextSpans.skipTo(this.localDocID);
                    if (contextSpans.doc() != this.localDocID) break;
                }
                if (contextSpans.start() <= this.getStartPos() && contextSpans.end() >= this.getStartPos()) {
                    int n = newStart = contextSpans.start() > newStart ? contextSpans.start() : newStart;
                    if (contextSpans.isPayloadAvailable()) {
                        try {
                            bb.rewind();
                            for (byte[] b : contextSpans.getPayload()) {
                                if (b[0] != 64) continue;
                                bb.rewind();
                                bb.put(b);
                                bb.position(1);
                                newStartChar = bb.getInt();
                                newEndChar = bb.getInt();
                            }
                        }
                        catch (Exception e) {
                            log.warn("Some problems with ByteBuffer: {}", (Object)e.getMessage());
                        }
                    }
                } else {
                    newEndChar = 0;
                }
                if (contextSpans.end() < this.getEndPos()) continue;
                newEnd = contextSpans.end();
                if (newEndChar != 0 || !contextSpans.isPayloadAvailable()) break;
                try {
                    bb.rewind();
                    for (byte[] b : contextSpans.getPayload()) {
                        if (b[0] != 64) continue;
                        bb.rewind();
                        bb.put(b);
                        bb.position(1);
                        newEndChar = bb.getInt(1);
                        break block6;
                    }
                    break;
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                    break;
                }
            }
            return new int[]{newStart, newEnd, newStartChar, newEndChar};
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return new int[]{-1, -1, -1, -1};
        }
    }

    private void _reset() {
        this.processed = false;
        this.snippetHTML = null;
        this.snippetBrackets = null;
        this.snippetTokens = null;
        this.identifier = null;
        if (this.span != null) {
            this.span.clear();
        }
    }

    private boolean _processHighlight() {
        if (this.processed) {
            return true;
        }
        if (this.positionsToOffset == null || this.localDocID == -1) {
            return false;
        }
        PositionsToOffset pto = this.positionsToOffset;
        pto.add(this.localDocID, this.getStartPos());
        pto.add(this.localDocID, this.getEndPos() - 1);
        if (this.innerMatchEndPos != 1) {
            this.addHighlight(this.innerMatchStartPos, this.innerMatchEndPos, -1);
        }
        if (this.highlight != null) {
            for (Highlight hl : this.highlight) {
                if (hl.start < this.getStartPos() || hl.end > this.getEndPos() || hl.end == -99999 || hl.end == -99998) continue;
                pto.add(this.localDocID, hl.start);
                pto.add(this.localDocID, hl.end);
            }
        }
        if (!(this.span != null && this.span.size() != 0 || this._processHighlightSpans())) {
            return false;
        }
        ArrayList<int[]> stack = this._processHighlightStack();
        if (this.tempSnippet == null) {
            this.processed = true;
            return false;
        }
        this._processHighlightSnippet(this.tempSnippet, stack);
        this.processed = true;
        return true;
    }

    private void _processHighlightSnippet(String clean, ArrayList<int[]> stack) {
        int pos = 0;
        int oldPos = 0;
        boolean exceeded = false;
        this.snippetArray = new HighlightCombinator();
        for (int[] element : stack) {
            int n = pos = element[3] != 0 ? element[0] : element[1];
            if (pos > oldPos) {
                if (pos > clean.length()) {
                    pos = clean.length();
                    exceeded = true;
                }
                if (pos > 0 && pos > oldPos) {
                    this.snippetArray.addString(KrillString.codePointSubstring(clean, oldPos, pos));
                }
                oldPos = pos;
            }
            if (element[3] == 0) {
                this.snippetArray.addClose(element[2]);
                continue;
            }
            if (!exceeded && element[3] == 2) {
                this.snippetArray.addEmpty(element[2]);
                continue;
            }
            if (!exceeded && element[3] == 3) {
                this.snippetArray.addMarker(element[2]);
                continue;
            }
            if (exceeded) break;
            this.snippetArray.addOpen(element[2]);
        }
        if (clean.length() > pos && pos >= 0) {
            this.snippetArray.addString(KrillString.codePointSubstring(clean, pos));
        }
    }

    @JsonIgnore
    public ObjectNode getSnippetTokens() {
        int i;
        ArrayNode tokens;
        ObjectNode json = this.mapper.createObjectNode();
        if (!this._processHighlight()) {
            return null;
        }
        if (this.processed && this.snippetTokens != null) {
            return this.snippetTokens;
        }
        if (this.positionsToOffset == null || this.localDocID == -1) {
            return null;
        }
        PositionsToOffset pto = this.positionsToOffset;
        int ldid = this.localDocID;
        int startContext = -1;
        int endContext = -1;
        int startContextChar = -1;
        int endContextChar = -1;
        int pdl = this.getPrimaryDataLength();
        if (this.getContext().isSpanDefined()) {
            int[] spanContext = this.expandContextToSpan(this.positionsToOffset.getLeafReader(), null, "tokens", this.context.getSpanContext());
            startContext = spanContext[0];
            endContext = spanContext[1];
            startContextChar = spanContext[2];
            endContextChar = spanContext[3];
        }
        if (endContext == -1) {
            if (this.context.left.isToken() && this.context.left.getLength() > 0 && (startContext = this.startPos - this.context.left.getLength()) < 0) {
                startContext = 0;
            }
            if (this.context.right.isToken() && this.context.right.getLength() > 0) {
                endContext = this.endPos + this.context.right.getLength() - 1;
            }
        }
        if (startContext == -1) {
            startContext = this.startPos;
        }
        if (endContext == -1) {
            endContext = this.endPos - 1;
        }
        for (int i2 = startContext; i2 < endContext; ++i2) {
            pto.add(ldid, i2);
        }
        if (startContextChar == -1) {
            startContextChar = pto.start(ldid, startContext);
        }
        if (endContextChar == -1) {
            endContextChar = pto.end(ldid, endContext);
        }
        if (endContextChar == -1 || endContextChar == 0 || endContextChar > pdl) {
            this.tempSnippet = this.getPrimaryData(startContextChar);
            this.endMore = false;
        } else {
            this.tempSnippet = this.getPrimaryData(startContextChar, endContextChar);
        }
        if (startContext == 0) {
            this.startMore = false;
        }
        if (startContext < this.startPos) {
            tokens = json.putArray("left");
            for (i = startContext; i < this.startPos; ++i) {
                Integer[] offsets = pto.span(ldid, i);
                tokens.add(KrillString.codePointSubstring(this.tempSnippet, offsets[0] - startContextChar, offsets[1] - startContextChar));
            }
        }
        tokens = json.putArray("match");
        for (i = this.startPos; i < this.endPos; ++i) {
            Integer[] offsets = pto.span(ldid, i);
            if (offsets == null) continue;
            tokens.add(KrillString.codePointSubstring(this.tempSnippet, offsets[0] - startContextChar, offsets[1] - startContextChar));
        }
        if (endContext > this.endPos) {
            Integer[] offsets;
            tokens = null;
            for (i = this.endPos; i < endContext && (offsets = pto.span(ldid, i)) != null; ++i) {
                if (tokens == null) {
                    tokens = json.putArray("right");
                }
                tokens.add(KrillString.codePointSubstring(this.tempSnippet, offsets[0] - startContextChar, offsets[1] - startContextChar));
            }
        }
        if (this.highlight != null) {
            ArrayNode classes = null;
            for (Highlight highlight : this.highlight) {
                if (highlight.number < 0 || highlight.number > 255 || highlight.end == -99999 || highlight.end == -99998) continue;
                if (classes == null) {
                    classes = json.putArray("classes");
                }
                ArrayNode cls = this.mapper.createArrayNode();
                cls.add(highlight.number);
                cls.add(highlight.start - this.startPos);
                cls.add(highlight.end - this.startPos);
                classes.add(cls);
            }
        }
        this.snippetTokens = json;
        return this.snippetTokens;
    }

    @JsonIgnore
    public String getSnippetHTML() {
        String elemString;
        HighlightCombinatorElement elem;
        if (!this._processHighlight()) {
            return null;
        }
        if (this.processed && this.snippetHTML != null) {
            return this.snippetHTML;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder rightContext = new StringBuilder();
        HashSet joins = new HashSet(100);
        short start = 0;
        short end = this.snippetArray.size();
        end = (short)(end - 1);
        FixedBitSet level = new FixedBitSet(255);
        level.set(0, 255);
        byte[] levelCache = new byte[255];
        sb.append("<span class=\"context-left\">");
        if (this.startMore) {
            sb.append("<span class=\"more\"></span>");
        }
        while (end > 0) {
            elem = this.snippetArray.get(start);
            if (elem.type == 1 || elem.type == 2) break;
            elemString = elem.toHTML(this, level, levelCache, joins);
            sb.append(elemString);
            start = (short)(start + 1);
        }
        sb.append("</span>");
        sb.append("<span class=\"match\">");
        if (this.startCutted) {
            sb.append("<span class=\"cutted\"></span>");
        }
        while (start <= end) {
            elem = this.snippetArray.get(start);
            if (elem != null) {
                elemString = elem.toHTML(this, level, levelCache, joins);
                sb.append(elemString);
                if (elem.type == 2 && elem.number == -99997) {
                    start = (short)(start + 1);
                    break;
                }
            }
            start = (short)(start + 1);
        }
        if (this.endCutted) {
            sb.append("<span class=\"cutted\"></span>");
        }
        sb.append("</span>");
        sb.append("<span class=\"context-right\">");
        while (start <= end) {
            elem = this.snippetArray.get(start);
            if (elem != null) {
                elemString = elem.toHTML(this, level, levelCache, joins);
                sb.append(elemString);
            }
            start = (short)(start + 1);
        }
        if (this.endMore) {
            sb.append("<span class=\"more\"></span>");
        }
        sb.append("</span>");
        this.snippetHTML = sb.toString();
        return this.snippetHTML;
    }

    @JsonIgnore
    public String getSnippetBrackets() {
        if (!this._processHighlight()) {
            return null;
        }
        if (this.processed && this.snippetBrackets != null) {
            return this.snippetBrackets;
        }
        short start = 0;
        short end = this.snippetArray.size();
        end = (short)(end - 1);
        StringBuilder sb = new StringBuilder();
        if (this.startMore) {
            sb.append("... ");
        }
        HighlightCombinatorElement elem = this.snippetArray.getFirst();
        while (end > 0) {
            elem = this.snippetArray.get(start);
            if (elem.type == 1 || elem.type == 2) break;
            sb.append(elem.toBrackets(this));
            start = (short)(start + 1);
        }
        sb.append("[");
        if (this.startCutted) {
            sb.append("<!>");
        }
        while (start <= end) {
            elem = this.snippetArray.get(start);
            if (elem != null) {
                sb.append(elem.toBrackets(this));
                if (elem.type == 2 && elem.number == -99997) {
                    start = (short)(start + 1);
                    break;
                }
            }
            start = (short)(start + 1);
        }
        if (this.endCutted) {
            sb.append("<!>");
        }
        sb.append("]");
        while (start <= end) {
            elem = this.snippetArray.get(start);
            if (elem != null) {
                sb.append(elem.toBrackets(this));
            }
            start = (short)(start + 1);
        }
        if (this.endMore) {
            sb.append(" ...");
        }
        this.snippetBrackets = sb.toString();
        return this.snippetBrackets;
    }

    private ArrayList<int[]> _processHighlightStack() {
        LinkedList<int[]> openList = new LinkedList<int[]>();
        LinkedList<int[]> closeList = new LinkedList<int[]>();
        this._filterMultipleIdentifiers();
        openList.addAll(this.span);
        closeList.addAll(this.span);
        Collections.sort(openList, new OpeningTagComparator());
        Collections.sort(closeList, new ClosingTagComparator());
        ArrayList<int[]> stack = new ArrayList<int[]>(openList.size() * 2);
        while (!openList.isEmpty() || !closeList.isEmpty()) {
            int[] e;
            if (openList.isEmpty()) {
                int pf = ((int[])closeList.peekFirst())[1];
                if (pf != -99999 && pf != -99998) {
                    int[] e2 = (int[])((int[])closeList.removeFirst()).clone();
                    stack.add(e2);
                    continue;
                }
                closeList.removeFirst();
                continue;
            }
            if (closeList.isEmpty()) {
                int[] e3 = (int[])((int[])openList.removeFirst()).clone();
                if (e3[1] != -99999 && e3[1] != -99998) continue;
                e3[3] = e3[1] == -99999 ? 2 : 3;
                e3[1] = e3[0];
                stack.add(e3);
                continue;
            }
            int clpf = ((int[])closeList.peekFirst())[1];
            int olpf = ((int[])openList.peekFirst())[1];
            if (clpf == -99999 || clpf == -99998) {
                closeList.removeFirst();
                continue;
            }
            if ((olpf == -99999 || olpf == -99998) && ((int[])closeList.peekFirst())[1] >= ((int[])openList.peekFirst())[0]) {
                e = (int[])((int[])openList.removeFirst()).clone();
                e[1] = e[0];
                e[3] = olpf == -99999 ? 2 : 3;
                stack.add(e);
                continue;
            }
            if (((int[])openList.peekFirst())[0] < ((int[])closeList.peekFirst())[1]) {
                e = (int[])((int[])openList.removeFirst()).clone();
                e[3] = 1;
                stack.add(e);
                continue;
            }
            e = (int[])closeList.removeFirst();
            stack.add(e);
        }
        return stack;
    }

    public void overrideMatchPosition(int start, int end) {
        this.innerMatchStartPos = start;
        this.innerMatchEndPos = end;
    }

    private boolean _processHighlightSpans() {
        int ldid = this.localDocID;
        int startPosChar = -1;
        int endPosChar = -1;
        if (this.positionsToOffset == null) {
            return false;
        }
        startPosChar = this.positionsToOffset.start(ldid, this.startPos);
        if (this.potentialStartPosChar != -1 && startPosChar > this.potentialStartPosChar) {
            startPosChar = this.potentialStartPosChar;
        }
        if ((endPosChar = this.positionsToOffset.end(ldid, this.endPos - 1)) < this.potentialEndPosChar) {
            endPosChar = this.potentialEndPosChar;
        }
        this.identifier = null;
        if (this.span == null) {
            this.span = new LinkedList();
        }
        int[] intArray = this._processOffsetChars(ldid, startPosChar, endPosChar);
        int startOffsetChar = startPosChar - intArray[0];
        int endRelOffsetChar = intArray[1];
        if (this.innerMatchEndPos == -1) {
            this.span.add(intArray);
        }
        intArray = new int[]{intArray[0], intArray[1], -99997, 0};
        this.span.add(intArray);
        if (this.highlight != null) {
            for (Highlight highlight : this.highlight) {
                int start = -1;
                int end = -1;
                if (highlight.end != -99999 && highlight.end != -99998) {
                    start = this.positionsToOffset.start(ldid, highlight.start);
                    end = this.positionsToOffset.end(ldid, highlight.end);
                } else {
                    start = highlight.start;
                    end = highlight.end;
                }
                start -= startOffsetChar;
                if (end != -99999 && end != -99998 && (end -= startOffsetChar) > endRelOffsetChar) {
                    end = endRelOffsetChar;
                }
                if (start < 0 || end < 0 | start > endRelOffsetChar && end != -99999 && end != -99998) continue;
                intArray = new int[]{start, end, highlight.number, 0};
                this.span.add(intArray);
            }
        }
        return true;
    }

    private int[] _processOffsetChars(int ldid, int startPosChar, int endPosChar) {
        int startOffsetChar = -1;
        int endOffsetChar = -1;
        int startOffset = -1;
        int endOffset = -1;
        if (this.getContext().isSpanDefined()) {
            this.startMore = false;
            this.endMore = false;
            int[] spanContext = this.expandContextToSpan(this.positionsToOffset.getLeafReader(), null, "tokens", this.context.getSpanContext());
            startOffset = spanContext[0];
            endOffset = spanContext[1];
            startOffsetChar = spanContext[2];
            endOffsetChar = spanContext[3];
        }
        if (endOffset == -1) {
            PositionsToOffset pto = this.positionsToOffset;
            if (this.context.left.isToken()) {
                startOffset = this.startPos - this.context.left.getLength();
                pto.add(ldid, startOffset);
            } else {
                startOffsetChar = startPosChar - this.context.left.getLength();
            }
            if (this.context.right.isToken()) {
                endOffset = this.endPos + this.context.right.getLength() - 1;
                pto.add(ldid, endOffset);
            } else {
                int n = endOffsetChar = endPosChar == -1 ? -1 : endPosChar + this.context.right.getLength();
            }
            if (startOffset != -1) {
                startOffsetChar = pto.start(ldid, startOffset);
            }
            if (endOffset != -1) {
                endOffsetChar = pto.end(ldid, endOffset);
            }
        }
        if (startOffsetChar > startPosChar) {
            startOffsetChar = startPosChar;
        } else if (startOffsetChar < 0) {
            startOffsetChar = 0;
        }
        if (startOffsetChar == 0) {
            this.startMore = false;
        }
        if (endOffsetChar != -1 && endOffsetChar < endPosChar) {
            endOffsetChar = endPosChar;
        }
        if (endOffsetChar > -1 && endOffsetChar < this.getPrimaryDataLength()) {
            this.tempSnippet = this.getPrimaryData(startOffsetChar, endOffsetChar);
        } else {
            this.tempSnippet = this.getPrimaryData(startOffsetChar);
            this.endMore = false;
        }
        return new int[]{startPosChar - startOffsetChar, endPosChar - startOffsetChar, -1, 0};
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode json = (ObjectNode)super.toJsonNode();
        if (this.context != null) {
            json.set("context", this.getContext().toJsonNode());
        }
        if (this.version != null) {
            json.put("version", this.getVersion());
        }
        if (this.startPage != -1) {
            ArrayNode pages = this.mapper.createArrayNode();
            pages.add(this.startPage);
            if (this.endPage != -1 && this.endPage != this.startPage) {
                pages.add(this.endPage);
            }
            json.set("pages", pages);
        }
        if (this.hasSnippet) {
            json.put("snippet", this.getSnippetHTML());
        }
        if (this.hasTokens) {
            json.set("tokens", this.getSnippetTokens());
        }
        ArrayNode fields = json.putArray("fields");
        for (MetaField mf : this.mFields) {
            fields.add(mf.toJsonNode());
            String mfs = mf.key;
            String value = this.getFieldValue(mfs);
            if (value == null || json.has(mfs)) continue;
            json.set(mfs, new TextNode(value));
        }
        this.addMessage(0, "Support for flat field values is deprecated", new String[0]);
        return json;
    }

    @Override
    public String toJsonString() {
        JsonNode json = this.toJsonNode();
        if (json.size() == 0) {
            return "{}";
        }
        try {
            return this.mapper.writeValueAsString(json);
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
            return "{}";
        }
    }

    public ObjectNode toTokenList() {
        int i;
        ObjectNode json = this.mapper.createObjectNode();
        if (this.getDocID() != null) {
            json.put("textSigle", this.getDocID());
        } else if (this.getTextSigle() != null) {
            json.put("textSigle", this.getTextSigle());
        }
        ArrayNode tokens = json.putArray("tokens");
        PositionsToOffset pto = this.positionsToOffset;
        for (i = this.getStartPos(); i < this.getEndPos(); ++i) {
            pto.add(this.localDocID, i);
        }
        for (i = this.getStartPos(); i < this.getEndPos(); ++i) {
            ArrayNode token = tokens.addArray();
            Integer[] integerArray = pto.span(this.localDocID, i);
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int offset = integerArray[j];
                token.add(offset);
            }
        }
        return json;
    }

    private void _filterMultipleIdentifiers() {
        ArrayList<Integer> removeDuplicate = new ArrayList<Integer>(10);
        HashSet<String> identifiers = new HashSet<String>(20);
        for (int i = 0; i < this.span.size(); ++i) {
            int highlightNumber = this.span.get(i)[2];
            if (highlightNumber >= -1) continue;
            String idNumber = this.identifierNumber.get(highlightNumber);
            if (identifiers.contains(idNumber)) {
                removeDuplicate.add(i);
                continue;
            }
            identifiers.add(idNumber);
        }
        Collections.sort(removeDuplicate);
        Collections.reverse(removeDuplicate);
        Iterator iterator = removeDuplicate.iterator();
        while (iterator.hasNext()) {
            int delete = (Integer)iterator.next();
            this.span.remove(delete);
        }
    }

    @JsonIgnore
    public String getClassID(int nr) {
        return this.identifierNumber.get(nr);
    }

    @JsonIgnore
    public String getAnnotationID(int nr) {
        return this.annotationNumber.get(nr);
    }

    @JsonIgnore
    public Relation getRelationID(int nr) {
        return this.relationNumber.get(nr);
    }

    private class Highlight {
        public int start;
        public int end;
        public int number = -1;

        public Highlight(int start, int end, String annotation, int refStart, int refEnd) {
            this.start = start;
            this.end = end;
            this.number = Match.this.relationNumberCounter++;
            Match.this.relationNumber.put(this.number, new Relation(annotation, refStart, refEnd));
        }

        public Highlight(int start, int end, String annotation) {
            this.start = start;
            this.end = end;
            if (Match.this.annotationNumberCounter < 2048) {
                this.number = Match.this.annotationNumberCounter++;
                Match.this.annotationNumber.put(this.number, annotation);
            }
        }

        public Highlight(int start, int end, int number) {
            this.start = start;
            this.end = end;
            this.number = number;
        }

        public Highlight(int start, int pagenumber) {
            this.start = start;
            this.end = -99999;
            this.number = pagenumber;
        }

        public Highlight(int start, String marker) {
            this.start = start;
            this.end = -99998;
            if (Match.this.annotationNumberCounter < 2048) {
                this.number = Match.this.annotationNumberCounter++;
                Match.this.annotationNumber.put(this.number, marker);
            }
        }
    }

    private class OpeningTagComparator
    implements Comparator<int[]> {
        private OpeningTagComparator() {
        }

        @Override
        public int compare(int[] arg0, int[] arg1) {
            if (arg0[0] > arg1[0]) {
                return 1;
            }
            if (arg0[0] == arg1[0]) {
                int end0 = arg0[1];
                int end1 = arg1[1];
                if (arg0[1] == -99999 || arg0[1] == -99998) {
                    end0 = arg0[0];
                }
                if (arg1[1] == -99999 || arg1[1] == -99998) {
                    end1 = arg1[0];
                }
                if (end0 > end1) {
                    return -1;
                }
                if (end0 == end1) {
                    if (arg0[2] > arg1[2]) {
                        return 1;
                    }
                    if (arg0[2] < arg1[2]) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            return -1;
        }
    }

    private class ClosingTagComparator
    implements Comparator<int[]> {
        private ClosingTagComparator() {
        }

        @Override
        public int compare(int[] arg0, int[] arg1) {
            int end0 = arg0[1];
            int end1 = arg1[1];
            if (arg0[1] == -99999 || arg0[1] == -99998) {
                end0 = arg0[0];
            }
            if (arg1[1] == -99999 || arg1[1] == -99998) {
                end1 = arg1[0];
            }
            if (end0 > end1) {
                return 1;
            }
            if (end0 == end1) {
                if (arg0[0] < arg1[0]) {
                    return 1;
                }
                if (arg0[0] == arg1[0]) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }
}

