/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.ranker;

import java.util.List;
import java.util.Map;
import lemming.lemma.LemmaCandidate;
import lemming.lemma.LemmaCandidateGenerator;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.ranker.RankerInstance;
import lemming.lemma.ranker.RankerModel;

public class Ranker
implements LemmatizerGenerator {
    private static final long serialVersionUID = 1L;
    private RankerModel model_;
    private List<LemmaCandidateGenerator> generators_;
    private int num_candidates_ = -1;

    public Ranker(RankerModel model, List<LemmaCandidateGenerator> generators) {
        this.model_ = model;
        this.generators_ = generators;
    }

    @Override
    public String lemmatize(LemmaInstance instance) {
        LemmaCandidateSet set = new LemmaCandidateSet();
        this.addCandidates_(instance, set);
        if (set.size() == 0) {
            return instance.getForm();
        }
        RankerInstance rinstance = new RankerInstance(instance, set);
        this.model_.addIndexes(rinstance, set, false);
        return this.model_.select(rinstance);
    }

    public void addCandidates_(LemmaInstance instance, LemmaCandidateSet set) {
        for (LemmaCandidateGenerator generator : this.generators_) {
            generator.addCandidates(instance, set);
        }
    }

    @Override
    public void addCandidates(LemmaInstance instance, LemmaCandidateSet set) {
        this.addCandidates_(instance, set);
        if (this.num_candidates_ >= 0 && set.size() > this.num_candidates_) {
            RankerInstance rinstance = new RankerInstance(instance, set);
            this.model_.addIndexes(rinstance, set, false);
            List<Double> scores = this.model_.scores(rinstance);
            scores.sort((o1, o2) -> -Double.compare(o1, o2));
            double lowest_score = scores.get(this.num_candidates_ - 1);
            LemmaCandidateSet copy_set = new LemmaCandidateSet(set);
            set.clear();
            for (Map.Entry<String, LemmaCandidate> entry : copy_set) {
                String lemma = entry.getKey();
                LemmaCandidate candidate = entry.getValue();
                if (!(candidate.getScore() + 1.0E-5 > lowest_score)) continue;
                candidate.setFeatureIndexes(null);
                candidate.setScore(0.0);
                set.addCandidate(lemma, candidate);
            }
        }
        if (set.size() == 0) {
            set.getCandidate(instance.getForm());
        }
    }

    @Override
    public boolean isOOV(LemmaInstance instance) {
        return this.model_.isOOV(instance);
    }

    public RankerModel getModel() {
        return this.model_;
    }

    public void setNumCandidates(int num_candidates) {
        this.num_candidates_ = num_candidates;
    }
}

