/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import marmot.util.Collectable;

public class Trie<E extends Collectable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private E content_ = null;
    private Map<Character, Trie<E>> children_ = null;

    public Map<Character, Trie<E>> getChildren() {
        return this.children_;
    }

    public Trie<E> addWord(String word, E content) {
        return this.addWord(word, 0, content);
    }

    private Trie<E> addWord(String word, int index, E content) {
        if (index >= word.length()) {
            this.add(content);
            return this;
        }
        char c = word.charAt(index);
        if (this.children_ == null) {
            this.children_ = new HashMap<Character, Trie<E>>();
        }
        Trie trie = this.children_.computeIfAbsent(Character.valueOf(c), k -> new Trie());
        return trie.addWord(word, index + 1, content);
    }

    public Trie<E> getChild(char c) {
        if (this.children_ == null) {
            return null;
        }
        return this.children_.get(Character.valueOf(c));
    }

    public boolean isTerminal() {
        return this.content_ != null;
    }

    public E getContent() {
        return this.content_;
    }

    public String toString() {
        return "Trie: " + this.content_ + " " + this.children_;
    }

    public void add(E content) {
        if (content != null) {
            if (this.content_ == null) {
                this.content_ = content.copy();
            } else {
                this.content_.add((Collectable)content);
            }
        }
    }

    public void propagateContent(int limit) {
        if (this.children_ != null) {
            for (Trie<E> child : this.children_.values()) {
                child.propagateContent(limit);
                this.add(child.content_);
            }
            if (this.content_ != null && this.content_.sum() > limit) {
                this.content_ = null;
            }
            Iterator<Trie<E>> iterator2 = this.children_.values().iterator();
            while (iterator2.hasNext()) {
                Trie<E> child;
                child = iterator2.next();
                if (this.content_ != null && this.content_.equals(child.content_)) {
                    child.content_ = null;
                }
                if (child.content_ != null || child.children_ != null) continue;
                iterator2.remove();
            }
            if (this.children_.isEmpty()) {
                this.children_ = null;
            }
        }
    }

    public E getContent(String word) {
        return this.getContent(word, 0, this.content_);
    }

    public E getContent(String word, int index, E content) {
        if (index >= word.length()) {
            return content;
        }
        Trie<E> child = this.getChild(word.charAt(index));
        if (child == null) {
            return content;
        }
        if (child.content_ != null) {
            content = child.content_;
        }
        return child.getContent(word, index + 1, content);
    }
}

