/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.Document;

public class Erector
implements Receiver {
    private final Configuration config;
    private final Document domDocument;
    private final DOMSender sender;
    private DominoNode currentRoot;
    private final NamePool namePool;
    private String systemId;
    public static final int PARENT_POINTER_INTERVAL = 10;
    private DominoTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private static final int NULL_FP = 1048575;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];

    public Erector(Document doc, String systemId, Configuration config) {
        this.sender = new DOMSender(doc, this);
        this.sender.setSystemId(systemId);
        this.setSystemId(systemId);
        this.domDocument = doc;
        this.config = config;
        this.namePool = config.getNamePool();
    }

    public DominoTree erect() throws XPathException {
        this.sender.send();
        this.tree.setSystemId(this.systemId);
        return this.tree;
    }

    public DominoTree getTree() {
        return this.tree;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    @Override
    public void open() {
        if (this.tree == null) {
            this.tree = new DominoTree(this.config);
            this.tree.setSystemId(this.systemId);
            this.currentDepth = 0;
        }
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        int nodeNr;
        if (this.tree == null) {
            this.open();
        }
        DominoTree tt = this.tree;
        assert (tt != null);
        DominoNode doc = this.currentRoot = new DominoNode(tt, 0);
        doc.setSystemId(this.getSystemId());
        this.currentDepth = 0;
        this.prevAtDepth[0] = nodeNr = tt.addNode((short)9, 0, -1, this.domDocument);
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        tt.next[nodeNr] = -1;
        ++this.currentDepth;
    }

    @Override
    public void endDocument() throws XPathException {
        this.tree.addNode((short)11, 0, -1, null);
        --this.tree.numberOfNodes;
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void reset() {
        this.tree = null;
        this.currentDepth = 0;
        this.nodeNr = 0;
        this.ended = false;
    }

    @Override
    public void close() throws XPathException {
        DominoTree tt = this.tree;
        if (tt != null) {
            tt.addNode((short)11, 0, -1, null);
            tt.condense();
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        DominoTree tt = this.tree;
        assert (tt != null);
        boolean addParentPointer = false;
        if (this.siblingsAtDepth[this.currentDepth] > 10) {
            addParentPointer = true;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        int fp = elemName.obtainFingerprint(this.namePool);
        if (addParentPointer) {
            fp |= 0x1000000;
        }
        this.nodeNr = tt.addNode((short)1, this.currentDepth, fp, this.sender.getCurrentNode());
        if (addParentPointer) {
            tt.addParentPointer(this.nodeNr, this.prevAtDepth[this.currentDepth - 1]);
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = tt.getNode(this.nodeNr);
        } else {
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            this.prevAtDepth = Arrays.copyOf(this.prevAtDepth, this.currentDepth * 2);
            this.siblingsAtDepth = Arrays.copyOf(this.siblingsAtDepth, this.currentDepth * 2);
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        this.tree.setNamespaceMap(this.nodeNr, namespaces);
        int n = this.nodeNr;
        this.tree.nameCode[n] = this.tree.nameCode[n] | 0x4000000;
        for (AttributeInfo att : attributes) {
            int n2 = this.nodeNr;
            this.tree.nameCode[n2] = this.tree.nameCode[n2] | 0x2000000;
            NodeName attName = att.getNodeName();
            if (!ReceiverOption.contains(properties, 2048) && (!attName.getLocalPart().equals("id") || !attName.hasURI(NamespaceUri.XML))) continue;
            this.tree.registerID(this.nodeNr, att.getValue());
        }
        ++this.nodeNr;
    }

    @Override
    public void endElement() throws XPathException {
        DominoTree tt = this.tree;
        assert (tt != null);
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
    }

    public DominoNode getLastCompletedElement() {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getNode(this.currentDepth >= 0 ? this.prevAtDepth[this.currentDepth] : 0);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (!chars.isEmpty()) {
            this.nodeNr = this.makeTextNode(chars);
        }
    }

    protected int makeTextNode(UnicodeString chars) {
        DominoTree tt = this.tree;
        int n = tt.numberOfNodes - 1;
        if (n >= 0 && tt.nodeKind[n] == 3 && tt.depth[n] == this.currentDepth) {
            int n2 = n;
            tt.nameCode[n2] = tt.nameCode[n2] | 0x8000000;
            return n;
        }
        this.nodeNr = tt.addNode((short)3, this.currentDepth, 1048575, this.sender.getCurrentNode());
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n3 = this.currentDepth;
        this.siblingsAtDepth[n3] = this.siblingsAtDepth[n3] + 1;
        return this.nodeNr;
    }

    @Override
    public void processingInstruction(String piname, UnicodeString remainder, Location locationId, int properties) throws XPathException {
        DominoTree tt = this.tree;
        int fp = this.namePool.allocateFingerprint(NamespaceUri.NULL, piname);
        this.nodeNr = tt.addNode((short)7, this.currentDepth, fp, this.sender.getCurrentNode());
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        DominoTree tt = this.tree;
        this.nodeNr = tt.addNode((short)8, this.currentDepth, 1048575, this.sender.getCurrentNode());
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) {
        this.tree.addUnparsedEntity(name, uri, publicId);
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return null;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        if (this.tree != null) {
            this.tree.setSystemId(systemId);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public String getSystemId() {
        return null;
    }
}

