/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Query;
import net.sf.saxon.option.jdom2.JDOM2DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class JDOM2Query
extends Query {
    public List<JDOM2DocumentWrapper> preprocess(List<SAXSource> sources) throws XPathException {
        try {
            ArrayList<JDOM2DocumentWrapper> jdomSources = new ArrayList<JDOM2DocumentWrapper>(sources.size());
            for (SAXSource ss : sources) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(ss.getInputSource());
                doc.setBaseURI(ss.getSystemId());
                JDOM2DocumentWrapper jdom = new JDOM2DocumentWrapper(doc, this.getConfiguration());
                jdomSources.add(jdom);
            }
            return jdomSources;
        }
        catch (IOException | JDOMException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOM2Query().doQuery(args, "JDOM2Query");
    }
}

