/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.chunker.TrainingParams;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.util.model.ModelUtil;

public class ChunkerTrainerTool
extends AbstractTrainerTool<ChunkSample, TrainerToolParams> {
    public ChunkerTrainerTool() {
        super(ChunkSample.class, TrainerToolParams.class);
    }

    @Override
    public String getName() {
        return "ChunkerTrainerME";
    }

    @Override
    public String getShortDescription() {
        return "Trainer for the learnable chunker";
    }

    @Override
    public void run(String format, String[] args2) {
        ChunkerModel model;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", modelOutFile);
        try {
            ChunkerFactory chunkerFactory = ChunkerFactory.create(((TrainerToolParams)this.params).getFactory());
            model = ChunkerME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, this.mlParams, chunkerFactory);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("chunker", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

