/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.GroupBoundaryTester;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class GroupAdjacentTester
extends GroupBoundaryTester {
    private List<AtomicMatchKey> currentGroupingComparisonKey;
    private StringCollator collator;
    private AtomicSequence currentGroupingKey;
    private int implicitTimezone;

    public GroupAdjacentTester(ForEachGroup expression, XPathContext context) {
        super(expression, context);
        this.collator = expression.getCollation();
        this.implicitTimezone = context.getImplicitTimezone();
    }

    @Override
    public boolean notifyItem() throws XPathException {
        Expression groupingKey = this.getControllingExpression().getGroupingKey();
        ArrayList<AtomicMatchKey> comparisonKey = new ArrayList<AtomicMatchKey>();
        SequenceIterator<?> iter = groupingKey.iterate(this.getLocalContext());
        AtomicArray key = new AtomicArray(iter);
        for (AtomicValue val : key) {
            comparisonKey.add(val.getXPathComparable(false, this.collator, this.implicitTimezone));
        }
        boolean isNewGroup = this.currentGroupingComparisonKey == null || !this.currentGroupingComparisonKey.equals(comparisonKey);
        this.currentGroupingComparisonKey = comparisonKey;
        if (isNewGroup) {
            this.currentGroupingKey = key;
        }
        return isNewGroup;
    }

    public AtomicSequence getCurrentGroupingKey() {
        return this.currentGroupingKey;
    }
}

