/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.ParentConstructorAdjunct;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.trans.XPathException;

public class ResultDocumentAdjunct
extends ParentConstructorAdjunct {
    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        ResultDocument inst = (ResultDocument)this.getExpression();
        if (Streamability.getSweep(inst.getContentExpression()) == Sweep.CONSUMING) {
            return (watchManager, out, context) -> new ResultDocumentFeed(this.getExpression(), out, context);
        }
        return super.getFeedMaker(arg);
    }

    public static class ResultDocumentFeed
    extends ComplexNodeEventFeed {
        public ResultDocumentFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        protected void processLeft(XPathContext context) throws XPathException {
            ResultDocument instr = (ResultDocument)this.getExpression();
            Receiver out = instr.processLeft(context);
            this.setReceiver(out);
        }

        @Override
        protected void processRight(XPathContext context) throws XPathException {
            Receiver out = this.getReceiver();
            try {
                out.endDocument();
            }
            catch (XPathException err) {
                err.setXPathContext(context);
                throw err;
            }
            out.close();
        }
    }
}

