/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamerMap;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.AbsorbingFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.AdjacentTextNodeMergerAdjunct;
import com.saxonica.ee.stream.adjunct.ApplyImportsAdjunct;
import com.saxonica.ee.stream.adjunct.ApplyTemplatesAdjunct;
import com.saxonica.ee.stream.adjunct.ArrayBlockAdjunct;
import com.saxonica.ee.stream.adjunct.AscentFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.AtomicSequenceConverterAdjunct;
import com.saxonica.ee.stream.adjunct.AtomizerAdjunct;
import com.saxonica.ee.stream.adjunct.AxisExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.BlockAdjunct;
import com.saxonica.ee.stream.adjunct.CallTemplateAdjunct;
import com.saxonica.ee.stream.adjunct.CardinalityCheckerAdjunct;
import com.saxonica.ee.stream.adjunct.ChooseAdjunct;
import com.saxonica.ee.stream.adjunct.ConditionalBlockAdjunct;
import com.saxonica.ee.stream.adjunct.ContextItemExprAdjunct;
import com.saxonica.ee.stream.adjunct.CopyAdjunct;
import com.saxonica.ee.stream.adjunct.CopyOfAdjunct;
import com.saxonica.ee.stream.adjunct.CurrentGroupStreamer;
import com.saxonica.ee.stream.adjunct.DeepDescentFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.DocumentInstrAdjunct;
import com.saxonica.ee.stream.adjunct.DocumentSorterAdjunct;
import com.saxonica.ee.stream.adjunct.ElementCreatorAdjunct;
import com.saxonica.ee.stream.adjunct.EmptyTextNodeRemoverAdjunct;
import com.saxonica.ee.stream.adjunct.FilterExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.FilterFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.FirstItemExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.ForEachAdjunct;
import com.saxonica.ee.stream.adjunct.ForEachGroupAdjunct;
import com.saxonica.ee.stream.adjunct.ForExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.ForkAdjunct;
import com.saxonica.ee.stream.adjunct.GeneralComparisonAdjunct;
import com.saxonica.ee.stream.adjunct.InstanceOfAdjunct;
import com.saxonica.ee.stream.adjunct.IsLastExprAdjunct;
import com.saxonica.ee.stream.adjunct.ItemCheckerAdjunct;
import com.saxonica.ee.stream.adjunct.IterateAdjunct;
import com.saxonica.ee.stream.adjunct.LetExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.LetExpressionAdjunctB;
import com.saxonica.ee.stream.adjunct.LiteralAdjunct;
import com.saxonica.ee.stream.adjunct.MergeInstrAdjunct;
import com.saxonica.ee.stream.adjunct.NextIterationAdjunct;
import com.saxonica.ee.stream.adjunct.NextMatchAdjunct;
import com.saxonica.ee.stream.adjunct.OnEmptyAdjunct;
import com.saxonica.ee.stream.adjunct.OnNonEmptyAdjunct;
import com.saxonica.ee.stream.adjunct.ResultDocumentAdjunct;
import com.saxonica.ee.stream.adjunct.RootExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.SequenceInstrAdjunct;
import com.saxonica.ee.stream.adjunct.ShallowDescentFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.SimpleNodeConstructorAdjunct;
import com.saxonica.ee.stream.adjunct.SingletonAtomizerAdjunct;
import com.saxonica.ee.stream.adjunct.SortExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.SubscriptExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.SwitchAdjunct;
import com.saxonica.ee.stream.adjunct.TailExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.TraceExprAdjunct;
import com.saxonica.ee.stream.adjunct.TryCatchAdjunct;
import com.saxonica.ee.stream.adjunct.UseAttributeSetAdjunct;
import com.saxonica.ee.stream.adjunct.UserFunctionCallAdjunct;
import com.saxonica.ee.stream.adjunct.VariableReferenceAdjunct;
import com.saxonica.ee.stream.adjunct.VennExpressionAdjunct;
import com.saxonica.ee.stream.adjunct.WherePopulatedAdjunct;
import com.saxonica.ee.stream.feed.BufferingFeed;
import com.saxonica.ee.stream.feed.CallableFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ConsumingOperand;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.ContextItemAccessorFunction;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.om.Function;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public class StreamingAdjunct {
    private static Map<String, Class<? extends StreamingAdjunct>> adjunctMap = new HashMap<String, Class<? extends StreamingAdjunct>>(50);
    private Configuration config;
    private Expression expression;

    private static void map(String s, Class<? extends StreamingAdjunct> a) {
        adjunctMap.put(s, a);
    }

    public static StreamingAdjunct makeStreamingAdjunct(Configuration config, Expression exp) {
        StreamingAdjunct adj = StreamingAdjunct.createStreamingAdjunct(config, exp);
        adj.setConfiguration(config);
        adj.setExpression(exp);
        return adj;
    }

    private static StreamingAdjunct createStreamingAdjunct(Configuration config, Expression exp) {
        if (exp instanceof DocumentSorter) {
            Expression operand = ((DocumentSorter)exp).getBaseExpression();
            if (operand instanceof SlashExpression && ((SlashExpression)operand).getActionExpression().isCallOn(Reverse.class)) {
                ((SlashExpression)operand).setStep(((SystemFunctionCall)((SlashExpression)operand).getActionExpression()).getArg(0));
            }
            return new DocumentSorterAdjunct();
        }
        if (exp instanceof IntegratedFunctionCall) {
            Object adjunct = ((IntegratedFunctionCall)exp).getFunction().getStreamingImplementation();
            if (adjunct instanceof StreamingAdjunct) {
                return (StreamingAdjunct)adjunct;
            }
        } else {
            UserFunctionCall ufc;
            FunctionStreamability ability;
            if (exp instanceof LetExpression) {
                Expression action = ((LetExpression)exp).getAction();
                if (Streamability.getPostureAndSweepIfKnown(action) != null && Streamability.getSweep(action) == Sweep.CONSUMING) {
                    return new LetExpressionAdjunctB();
                }
                return new LetExpressionAdjunct();
            }
            if (exp instanceof StreamInstr) {
                final StreamInstr stream = (StreamInstr)exp;
                return new StreamingAdjunct(){

                    @Override
                    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
                        Streamability.getStreamability(stream.getHref(), contextInfo, reasons);
                        return new PostureAndSweep(Posture.GROUNDED, Streamability.getSweep(stream.getHref()));
                    }
                };
            }
            if (exp instanceof SystemFunctionCall) {
                SystemFunctionCall call = (SystemFunctionCall)exp;
                String streamerName = call.getTargetFunction().getStreamerName();
                StreamingAdjunct sa = StreamerMap.getStreamingAdjunct(streamerName);
                if (sa == null) {
                    if (call.getTargetFunction() instanceof ContextItemAccessorFunction) {
                        Expression e2 = ((ContextItemAccessorFunction)call.getTargetFunction()).makeContextItemExplicit();
                        return StreamingAdjunct.makeStreamingAdjunct(config, e2);
                    }
                    return new StreamingAdjunct();
                }
                return sa;
            }
            if (exp instanceof UserFunctionCall && (ability = (ufc = (UserFunctionCall)exp).getFunction().getDeclaredStreamability()) != FunctionStreamability.UNCLASSIFIED) {
                if (ability == FunctionStreamability.FILTER) {
                    return new FilterFunctionCallAdjunct();
                }
                if (ability == FunctionStreamability.ABSORBING) {
                    if (Streamability.getPostureAndSweepIfKnown(ufc.getArg(0)) != null && Streamability.getPosture(ufc.getArg(0)) == Posture.GROUNDED) {
                        return new StreamingAdjunct();
                    }
                    return new AbsorbingFunctionCallAdjunct();
                }
                if (ability == FunctionStreamability.SHALLOW_DESCENT) {
                    if (Streamability.getPostureAndSweepIfKnown(ufc.getArg(0)) != null && Streamability.getPosture(ufc.getArg(0)) == Posture.GROUNDED) {
                        return new StreamingAdjunct();
                    }
                    return new ShallowDescentFunctionCallAdjunct();
                }
                if (ability == FunctionStreamability.DEEP_DESCENT) {
                    if (Streamability.getPostureAndSweepIfKnown(ufc.getArg(0)) != null && Streamability.getPosture(ufc.getArg(0)) == Posture.GROUNDED) {
                        return new StreamingAdjunct();
                    }
                    return new DeepDescentFunctionCallAdjunct();
                }
                if (ability == FunctionStreamability.ASCENT) {
                    if (Streamability.getPostureAndSweepIfKnown(ufc.getArg(0)) != null && Streamability.getPosture(ufc.getArg(0)) == Posture.GROUNDED) {
                        return new StreamingAdjunct();
                    }
                    return new AscentFunctionCallAdjunct();
                }
                return new UserFunctionCallAdjunct();
            }
        }
        if (exp.getStreamerName() != null) {
            Class<? extends StreamingAdjunct> aClass = adjunctMap.get(exp.getStreamerName());
            if (aClass == null) {
                throw new AssertionError((Object)("No streaming support for " + exp.getStreamerName()));
            }
            try {
                return aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new StreamingAdjunct();
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Expression exp = this.getExpression();
        Iterable<Operand> ops = exp.operands();
        return Streamability.generalStreamabilityRules(exp, ops, contextInfo, reasons);
    }

    public static int findConsumingArg(Expression expression, int knownConsumingArg) throws XPathException {
        if (knownConsumingArg == -1) {
            int i = 0;
            int arg = 0;
            for (Operand o : expression.operands()) {
                if (Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING) {
                    arg = i;
                }
                ++i;
            }
            if (arg == -1) {
                throw new XPathException("No consuming subexpression found");
            }
            return arg;
        }
        return knownConsumingArg;
    }

    public Pattern toStreamingPattern(Configuration config) {
        return null;
    }

    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Posture posture = Streamability.getPosture(this.getExpression());
        if (posture == Posture.STRIDING || posture == Posture.CRAWLING) {
            throw new XPathException("No watch implemented for " + this.getExpression().getExpressionName(), "SXST0067", this.getExpression().getLocation());
        }
        return null;
    }

    public FeedMaker getFeedMaker(int arg) throws XPathException {
        if (this instanceof FeedMaker) {
            return (FeedMaker)((Object)this);
        }
        return this.getDefaultFeedMaker(arg);
    }

    protected FeedMaker getDefaultFeedMaker(int arg) {
        boolean allowsMany = false;
        int n = 0;
        Operand streamingOp = null;
        for (Operand o : this.getExpression().operands()) {
            if (n++ != arg) continue;
            allowsMany = Cardinality.allowsMany(o.getRequiredType().getCardinality());
            streamingOp = o;
            break;
        }
        if (this.getExpression() instanceof StaticFunctionCall && !allowsMany) {
            Function fn = ((StaticFunctionCall)this.getExpression()).getTargetFunction();
            Expression[] args = ((StaticFunctionCall)this.getExpression()).getArguments();
            return (watchManager, out, context) -> new CallableFeed(fn, out, context, args);
        }
        assert (streamingOp != null);
        Expression proxy = streamingOp.getChildExpression();
        ConsumingOperand co = new ConsumingOperand(proxy);
        streamingOp.setChildExpression(co);
        co.getOperand().setOperandRole(new OperandRole(0, streamingOp.getUsage()));
        Streamability.setPostureAndSweep(co, Streamability.getPostureAndSweepIfKnown(proxy));
        return (watchManager, out, context) -> new BufferingFeed(this.getExpression(), out, context);
    }

    static {
        StreamingAdjunct.map("AdjacentTextNodeMerger", AdjacentTextNodeMergerAdjunct.class);
        StreamingAdjunct.map("ApplyImports", ApplyImportsAdjunct.class);
        StreamingAdjunct.map("ApplyTemplates", ApplyTemplatesAdjunct.class);
        StreamingAdjunct.map("ArrayBlock", ArrayBlockAdjunct.class);
        StreamingAdjunct.map("AtomicSequenceConverter", AtomicSequenceConverterAdjunct.class);
        StreamingAdjunct.map("Atomizer", AtomizerAdjunct.class);
        StreamingAdjunct.map("AxisExpression", AxisExpressionAdjunct.class);
        StreamingAdjunct.map("Block", BlockAdjunct.class);
        StreamingAdjunct.map("CallTemplate", CallTemplateAdjunct.class);
        StreamingAdjunct.map("CardinalityChecker", CardinalityCheckerAdjunct.class);
        StreamingAdjunct.map("Choose", ChooseAdjunct.class);
        StreamingAdjunct.map("ConditionalBlock", ConditionalBlockAdjunct.class);
        StreamingAdjunct.map("ContextItemExpr", ContextItemExprAdjunct.class);
        StreamingAdjunct.map("Copy", CopyAdjunct.class);
        StreamingAdjunct.map("CopyOf", CopyOfAdjunct.class);
        StreamingAdjunct.map("CurrentGroup", CurrentGroupStreamer.class);
        StreamingAdjunct.map("DocumentInstr", DocumentInstrAdjunct.class);
        StreamingAdjunct.map("DocumentSorterAdjunct", DocumentSorterAdjunct.class);
        StreamingAdjunct.map("ElementCreator", ElementCreatorAdjunct.class);
        StreamingAdjunct.map("EmptyTextNodeRemover", EmptyTextNodeRemoverAdjunct.class);
        StreamingAdjunct.map("FilterExpression", FilterExpressionAdjunct.class);
        StreamingAdjunct.map("FirstItemExpression", FirstItemExpressionAdjunct.class);
        StreamingAdjunct.map("ForEach", ForEachAdjunct.class);
        StreamingAdjunct.map("ForEachGroup", ForEachGroupAdjunct.class);
        StreamingAdjunct.map("ForExpression", ForExpressionAdjunct.class);
        StreamingAdjunct.map("Fork", ForkAdjunct.class);
        StreamingAdjunct.map("GeneralComparison", GeneralComparisonAdjunct.class);
        StreamingAdjunct.map("InstanceOf", InstanceOfAdjunct.class);
        StreamingAdjunct.map("IsLastExpr", IsLastExprAdjunct.class);
        StreamingAdjunct.map("ItemChecker", ItemCheckerAdjunct.class);
        StreamingAdjunct.map("Iterate", IterateAdjunct.class);
        StreamingAdjunct.map("Literal", LiteralAdjunct.class);
        StreamingAdjunct.map("MergeInstr", MergeInstrAdjunct.class);
        StreamingAdjunct.map("NextIteration", NextIterationAdjunct.class);
        StreamingAdjunct.map("NextMatch", NextMatchAdjunct.class);
        StreamingAdjunct.map("OnEmpty", OnEmptyAdjunct.class);
        StreamingAdjunct.map("OnNonEmpty", OnNonEmptyAdjunct.class);
        StreamingAdjunct.map("RootExpression", RootExpressionAdjunct.class);
        StreamingAdjunct.map("ResultDocument", ResultDocumentAdjunct.class);
        StreamingAdjunct.map("SequenceInstr", SequenceInstrAdjunct.class);
        StreamingAdjunct.map("SimpleNodeConstructor", SimpleNodeConstructorAdjunct.class);
        StreamingAdjunct.map("SingletonAtomizer", SingletonAtomizerAdjunct.class);
        StreamingAdjunct.map("SlashExpression", ForEachAdjunct.class);
        StreamingAdjunct.map("SortExpression", SortExpressionAdjunct.class);
        StreamingAdjunct.map("SubscriptExpression", SubscriptExpressionAdjunct.class);
        StreamingAdjunct.map("SwitchExpression", SwitchAdjunct.class);
        StreamingAdjunct.map("TailExpression", TailExpressionAdjunct.class);
        StreamingAdjunct.map("TraceExpr", TraceExprAdjunct.class);
        StreamingAdjunct.map("TryCatch", TryCatchAdjunct.class);
        StreamingAdjunct.map("UseAttributeSet", UseAttributeSetAdjunct.class);
        StreamingAdjunct.map("VariableReference", VariableReferenceAdjunct.class);
        StreamingAdjunct.map("VennExpression", VennExpressionAdjunct.class);
        StreamingAdjunct.map("WherePopulated", WherePopulatedAdjunct.class);
    }
}

