/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.IndexInfo;
import de.ids_mannheim.korap.Krill;
import de.ids_mannheim.korap.KrillCollection;
import de.ids_mannheim.korap.KrillMeta;
import de.ids_mannheim.korap.index.FieldDocument;
import de.ids_mannheim.korap.index.KeywordAnalyzer;
import de.ids_mannheim.korap.index.PositionsToOffset;
import de.ids_mannheim.korap.index.SpanInfo;
import de.ids_mannheim.korap.index.TermInfo;
import de.ids_mannheim.korap.index.TextAnalyzer;
import de.ids_mannheim.korap.index.TimeOutThread;
import de.ids_mannheim.korap.response.Match;
import de.ids_mannheim.korap.response.MatchCollector;
import de.ids_mannheim.korap.response.MetaFields;
import de.ids_mannheim.korap.response.Result;
import de.ids_mannheim.korap.response.SearchContext;
import de.ids_mannheim.korap.response.Text;
import de.ids_mannheim.korap.util.Fingerprinter;
import de.ids_mannheim.korap.util.KrillDate;
import de.ids_mannheim.korap.util.KrillProperties;
import de.ids_mannheim.korap.util.QueryException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrillIndex
implements IndexInfo {
    private static final Logger log = LoggerFactory.getLogger(KrillIndex.class);
    public static final boolean DEBUG = false;
    private int autoCommit = 10000;
    private String version = "Unknown";
    private String name = "Unknown";
    private String indexRevision;
    private IndexReader reader;
    private IndexWriter writer;
    private boolean readerOpen = false;
    private boolean writerOpen = false;
    private Directory directory;
    private int commitCounter = 0;
    private HashMap termContexts;
    private ObjectMapper mapper = new ObjectMapper();

    public KrillIndex() throws IOException {
        this(new RAMDirectory());
    }

    public KrillIndex(Directory directory) throws IOException {
        Properties prop = KrillProperties.loadDefaultProperties();
        Properties info = KrillProperties.loadInfo();
        if (info != null) {
            this.version = info.getProperty("krill.version");
            this.name = info.getProperty("krill.name");
        }
        String autoCommitStr = null;
        if (prop != null) {
            autoCommitStr = prop.getProperty("krill.index.commit.auto");
        }
        if (autoCommitStr != null) {
            try {
                this.autoCommit = Integer.parseInt(autoCommitStr);
            }
            catch (NumberFormatException e) {
                log.error("krill.index.commit.auto expected to be a numerical value");
            }
        }
        this.directory = directory;
    }

    public KrillIndex(Path path) throws IOException {
        Properties prop = KrillProperties.loadDefaultProperties();
        Properties info = KrillProperties.loadInfo();
        if (info != null) {
            this.version = info.getProperty("krill.version");
            this.name = info.getProperty("krill.name");
        }
        String autoCommitStr = null;
        if (prop != null) {
            autoCommitStr = prop.getProperty("krill.index.commit.auto");
        }
        if (autoCommitStr != null) {
            try {
                this.autoCommit = Integer.parseInt(autoCommitStr);
            }
            catch (NumberFormatException e) {
                log.error("krill.index.commit.auto expected to be a numerical value");
            }
        }
        this.directory = new MMapDirectory(path);
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public IndexReader reader() {
        if (!this.readerOpen) {
            this.openReader();
        }
        if (!this.readerOpen) {
            return null;
        }
        return this.reader;
    }

    public IndexWriter writer() throws IOException {
        if (!this.writerOpen) {
            this.openWriter();
        }
        if (!this.writerOpen) {
            return null;
        }
        return this.writer;
    }

    private void openWriter() {
        if (this.writerOpen) {
            return;
        }
        try {
            HashMap<String, Analyzer> analyzerPerField = new HashMap<String, Analyzer>();
            analyzerPerField.put("textClass", new KeywordAnalyzer());
            analyzerPerField.put("keywords", new KeywordAnalyzer());
            analyzerPerField.put("foundries", new KeywordAnalyzer());
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper(new TextAnalyzer(), analyzerPerField);
            this.writer = new IndexWriter(this.directory, new IndexWriterConfig(analyzer));
            this.writerOpen = true;
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
    }

    private void openReader() {
        if (this.readerOpen) {
            return;
        }
        try {
            this.reader = DirectoryReader.open(this.directory);
            this.readerOpen = true;
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
    }

    public void closeReader() throws IOException {
        if (this.readerOpen || this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.readerOpen = false;
        }
    }

    public void closeWriter() throws IOException {
        if (this.writerOpen || this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.writerOpen = false;
        }
    }

    public void close() throws IOException {
        this.closeWriter();
        this.closeReader();
    }

    public void commit(boolean force) throws IOException {
        if (this.commitCounter > 0 || !force) {
            this.commit();
        }
    }

    public void commit() throws IOException {
        log.info("Internal committing index ... ");
        this.writer().commit();
        this.commitCounter = 0;
        this.closeReader();
    }

    public int getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(int value) {
        this.autoCommit = value;
    }

    public FieldDocument upsertDoc(FieldDocument doc) {
        KrillDate indexLastModified;
        KrillDate indexCreationDate;
        block7: {
            KrillDate current;
            if (doc == null) {
                return doc;
            }
            String textSigle = doc.getTextSigle();
            indexCreationDate = current = new KrillDate(LocalDate.now());
            indexLastModified = current;
            if (textSigle != null) {
                QueryWrapperFilter filter = new QueryWrapperFilter(new TermQuery(new Term("textSigle", textSigle)));
                try {
                    if (this.reader() != null) {
                        for (LeafReaderContext atomic : this.reader().leaves()) {
                            int localDocID;
                            DocIdSet filterSet = ((Filter)filter).getDocIdSet(atomic, atomic.reader().getLiveDocs());
                            DocIdSetIterator filterIterator = filterSet.iterator();
                            if (filterIterator == null || (localDocID = filterIterator.nextDoc()) == Integer.MAX_VALUE) continue;
                            Document storedDoc = atomic.reader().document(localDocID);
                            if (storedDoc != null) {
                                IndexableField indexCreationField = storedDoc.getField("indexCreationDate");
                                indexCreationDate = indexCreationField == null ? current : new KrillDate(indexCreationField.numericValue().toString());
                            }
                            this.delDocs("textSigle", textSigle);
                            break block7;
                        }
                        break block7;
                    }
                    log.warn("Reader is null");
                }
                catch (IOException e) {
                    log.error("Unable to upsert document");
                }
            }
        }
        doc.addDate("indexCreationDate", indexCreationDate.toDisplay());
        doc.addDate("indexLastModified", indexLastModified.toDisplay());
        return this.addDoc(doc);
    }

    public FieldDocument upsertDoc(InputStream json, boolean gzip) {
        return this.upsertDoc(this._fromFile(json, gzip));
    }

    public FieldDocument addDoc(FieldDocument doc) {
        if (doc == null) {
            return doc;
        }
        try {
            this.writer().addDocument(doc.compile());
            if (++this.commitCounter > this.autoCommit) {
                this.commit();
                this.commitCounter = 0;
            }
            this.indexRevision = null;
        }
        catch (IOException e) {
            log.error("Unable to add document");
        }
        return doc;
    }

    public boolean delDocs(String field, String term) {
        if (field == null || term == null) {
            return false;
        }
        try {
            this.writer().deleteDocuments(new Term(field, term));
            if (++this.commitCounter > this.autoCommit) {
                this.commit();
                this.commitCounter = 0;
            }
            this.indexRevision = null;
            return true;
        }
        catch (IOException e) {
            log.error("Unable to delete documents");
            return false;
        }
    }

    public boolean delDoc(Integer uid) {
        if (uid < 0) {
            return false;
        }
        return this.delDocs("UID", uid.toString());
    }

    public FieldDocument addDoc(String json) {
        return this.addDoc(this._fromJson(json));
    }

    public FieldDocument addDoc(Integer uid, String json) {
        FieldDocument fd = this._fromJson(json);
        if (fd != null) {
            fd.setUID(uid);
            fd = this.addDoc(fd);
        }
        return fd;
    }

    public FieldDocument addDoc(InputStream json) {
        return this.addDoc(this._fromFile(json, false));
    }

    public FieldDocument addDoc(InputStream json, boolean gzip) {
        return this.addDoc(this._fromFile(json, gzip));
    }

    public FieldDocument addDoc(Integer uid, InputStream json, boolean gzip) {
        FieldDocument fd = this._fromFile(json, gzip);
        if (fd != null) {
            fd.setUID(uid);
            return this.addDoc(fd);
        }
        return fd;
    }

    private FieldDocument _fromJson(String json) {
        try {
            FieldDocument fd = this.mapper.readValue(json, FieldDocument.class);
            return fd;
        }
        catch (IOException e) {
            log.error("File json not found or unmappable: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    private FieldDocument _fromFile(InputStream json, boolean gzip) {
        try {
            if (gzip) {
                GZIPInputStream gzipFile = new GZIPInputStream(json);
                FieldDocument fd = this.mapper.readValue((InputStream)gzipFile, FieldDocument.class);
                gzipFile.close();
                return fd;
            }
            FieldDocument field = this.mapper.readValue(json, FieldDocument.class);
            json.close();
            return field;
        }
        catch (IOException e) {
            log.error("File {} not found", (Object)json, (Object)e);
            return null;
        }
    }

    public long numberOf(KrillCollection collection, String field, String type) {
        collection.setIndex(this);
        try {
            return collection.numberOf(field, type);
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
            return -1L;
        }
    }

    public long numberOf(String field, String type) {
        return this.numberOf(new KrillCollection(this), field, type);
    }

    public long numberOf(String type) {
        return this.numberOf("tokens", type);
    }

    public Text getDoc(String uid) {
        Text text = new Text();
        uid = Integer.valueOf(Integer.parseInt(uid)).toString();
        QueryWrapperFilter filter = new QueryWrapperFilter(new TermQuery(new Term("UID", uid)));
        try {
            for (LeafReaderContext atomic : this.reader().leaves()) {
                int localDocID;
                DocIdSet filterSet = ((Filter)filter).getDocIdSet(atomic, atomic.reader().getLiveDocs());
                DocIdSetIterator filterIterator = filterSet.iterator();
                if (filterIterator == null || (localDocID = filterIterator.nextDoc()) == Integer.MAX_VALUE) continue;
                Document doc = atomic.reader().document(localDocID);
                text.populateFields(doc);
                return text;
            }
        }
        catch (IOException e) {
            text.addError(600, "Unable to read index", e.getLocalizedMessage());
            log.warn(e.getLocalizedMessage());
        }
        text.addError(630, "Document not found", new String[0]);
        return text;
    }

    public String getMatchIDWithContext(String id) {
        return "";
    }

    public Match getMatch(String id) throws QueryException {
        return this.getMatchInfo(id, "tokens", false, (List<String>)null, (List<String>)null, false, true, false);
    }

    public Match getMatchInfo(String id, String field, String foundry, String layer, boolean includeSpans, boolean includeHighlights) throws QueryException {
        return this.getMatchInfo(id, field, true, foundry, layer, includeSpans, includeHighlights, false);
    }

    public Match getMatchInfo(String id, String field, String foundry, String layer, boolean includeSpans, boolean includeHighlights, boolean extendToSentence) throws QueryException {
        return this.getMatchInfo(id, field, true, foundry, layer, includeSpans, includeHighlights, extendToSentence);
    }

    public Match getMatchInfo(String id, String field, boolean info, String foundry, String layer, boolean includeSpans, boolean includeHighlights, boolean extendToSentence) throws QueryException {
        ArrayList<String> foundryList = new ArrayList<String>(1);
        if (foundry != null) {
            foundryList.add(foundry);
        }
        ArrayList<String> layerList = new ArrayList<String>(1);
        if (layer != null) {
            layerList.add(layer);
        }
        return this.getMatchInfo(id, field, info, foundryList, layerList, includeSpans, includeHighlights, extendToSentence);
    }

    public Match getMatchInfo(String idString, String field, boolean info, List<String> foundry, List<String> layer, boolean includeSpans, boolean includeHighlights, boolean extendToSentence) throws QueryException {
        return this.getMatchInfo(idString, field, info, foundry, layer, includeSpans, true, false, includeHighlights, extendToSentence);
    }

    public Match getMatchInfo(String idString, String field, boolean info, List<String> foundry, List<String> layer, boolean includeSpans, boolean includeSnippets, boolean includeTokens, boolean includeHighlights, boolean extendToSentence) throws QueryException {
        Match match = new Match(idString, includeHighlights);
        if (this.getVersion() != null) {
            match.setVersion(this.getVersion());
        }
        if (this.getName() != null) {
            match.setName(this.getName());
        }
        if (match.getStartPos() == -1) {
            return match;
        }
        if (includeTokens) {
            match.hasTokens = true;
        }
        if (includeSnippets) {
            match.hasSnippet = true;
        } else {
            includeHighlights = false;
            includeSpans = false;
            info = false;
        }
        BooleanQuery bool = new BooleanQuery();
        if (match.getTextSigle() != null) {
            bool.add(new TermQuery(new Term("textSigle", match.getTextSigle())), BooleanClause.Occur.MUST);
        } else if (match.getDocID() != null) {
            bool.add(new TermQuery(new Term("ID", match.getDocID())), BooleanClause.Occur.MUST);
            bool.add(new TermQuery(new Term("corpusID", match.getCorpusID())), BooleanClause.Occur.MUST);
        } else {
            match.addError(730, "Invalid match identifier", idString);
            return match;
        }
        QueryWrapperFilter filter = new QueryWrapperFilter(bool);
        CompiledAutomaton fst = null;
        ByteBuffer bbTerm = ByteBuffer.allocate(32);
        if (info) {
            StringBuilder regex = new StringBuilder();
            Pattern harmlessFoundry = Pattern.compile("^[-a-zA-Z0-9_]+$");
            Pattern harmlessLayer = Pattern.compile("^[-a-zA-Z0-9_:]+$");
            int i = 0;
            if (includeSpans) {
                regex.append("((\">\"|\"<\"\">\")\":\")?");
            }
            if (foundry != null && foundry.size() > 0) {
                for (i = foundry.size() - 1; i >= 0; --i) {
                    if (harmlessFoundry.matcher(foundry.get(i)).matches()) continue;
                    match.addError(970, "Invalid foundry requested", foundry.get(i));
                    return match;
                }
                if (foundry.size() > 0) {
                    regex.append("(");
                    Iterator<String> iter = foundry.iterator();
                    while (iter.hasNext()) {
                        regex.append(iter.next()).append("|");
                    }
                    regex.replace(regex.length() - 1, regex.length(), ")");
                    regex.append("\"/\"");
                    if (layer != null && layer.size() > 0) {
                        for (i = layer.size() - 1; i >= 0; --i) {
                            if (harmlessLayer.matcher(layer.get(i)).matches()) continue;
                            throw new QueryException("Invalid layer requested: " + layer.get(i));
                        }
                        if (layer.size() > 0) {
                            regex.append("(");
                            iter = layer.iterator();
                            while (iter.hasNext()) {
                                regex.append(iter.next()).append("|");
                            }
                            regex.replace(regex.length() - 1, regex.length(), ")");
                            regex.append("\":\"");
                        }
                    }
                }
            } else if (includeSpans) {
                regex.append("([^-is]|[-is][^:])");
            } else {
                regex.append("([^-is<>]|[-is>][^:]|<[^:>])");
            }
            regex.append("(.){1,}|_[0-9]+");
            RegExp regexObj = new RegExp(regex.toString(), 2);
            fst = new CompiledAutomaton(regexObj.toAutomaton());
        }
        try {
            for (LeafReaderContext atomic : this.reader().leaves()) {
                int localDocID;
                DocIdSet filterSet = ((Filter)filter).getDocIdSet(atomic, atomic.reader().getLiveDocs());
                DocIdSetIterator filterIterator = filterSet.iterator();
                if (filterIterator == null || (localDocID = filterIterator.nextDoc()) == Integer.MAX_VALUE) continue;
                Terms docTerms = atomic.reader().getTermVector(localDocID, field);
                ArrayList fields = (ArrayList)new Krill().getMeta().getFields().clone();
                if (fields.contains("@all")) {
                    fields = null;
                }
                HashSet<String> fieldsSet = new HashSet<String>(fields);
                fieldsSet.add(field);
                Document doc = fields != null ? atomic.reader().document(localDocID, fieldsSet) : atomic.reader().document(localDocID);
                PositionsToOffset pto = new PositionsToOffset(atomic, field);
                match.setPositionsToOffset(pto);
                match.setLocalDocID(localDocID);
                match.populateDocument(doc, field, fields);
                SearchContext context = match.getContext();
                match.overrideMatchPosition(match.getStartPos(), match.getEndPos() - 1);
                if (extendToSentence) {
                    String element = "base/s:s";
                    int[] spanContext = match.expandContextToSpan(element);
                    if (spanContext[0] >= 0 && spanContext[0] < spanContext[1]) {
                        if (spanContext[1] - spanContext[0] > match.getMaxMatchTokens()) {
                            int contextLength = match.getMaxMatchTokens() - match.getLength();
                            int halfContext = contextLength / 2;
                            int realLeftLength = match.getStartPos() - spanContext[0];
                            if (realLeftLength > halfContext) {
                                match.startCutted = true;
                                spanContext[0] = match.getStartPos() - halfContext;
                            }
                        }
                        match.setStartPos(spanContext[0]);
                        match.setEndPos(spanContext[1]);
                        match.potentialStartPosChar = spanContext[2];
                        match.potentialEndPosChar = spanContext[3];
                        match.startMore = false;
                        match.endMore = false;
                    } else {
                        match.addWarning(651, "Unable to extend context", new String[0]);
                    }
                }
                context.left.setToken(true).setLength(0);
                context.right.setToken(true).setLength(0);
                if (info) {
                    TermsEnum termsEnum = docTerms.intersect(fst, null);
                    DocsAndPositionsEnum docs = null;
                    SpanInfo termList = new SpanInfo(pto, localDocID);
                    while (termsEnum.next() != null) {
                        docs = termsEnum.docsAndPositions(null, docs, 2);
                        docs.nextDoc();
                        if (docs.docID() == Integer.MAX_VALUE) continue;
                        String termString = termsEnum.term().utf8ToString();
                        for (int i = 0; i < docs.freq(); ++i) {
                            TermInfo ti;
                            int pos = docs.nextPosition();
                            if (pos < match.getStartPos() || pos >= match.getEndPos()) continue;
                            BytesRef payload = docs.getPayload();
                            bbTerm.clear();
                            if (payload != null && payload.length <= bbTerm.capacity()) {
                                bbTerm.put(payload.bytes, payload.offset, payload.length);
                            }
                            if ((ti = new TermInfo(termString, pos, bbTerm).analyze()).getEndPos() >= match.getEndPos()) continue;
                            termList.add(ti);
                        }
                    }
                    for (TermInfo t : termList.getTerms()) {
                        if (t.getType().equals("term") || t.getType().equals("span")) {
                            match.addAnnotation(t.getStartPos(), t.getEndPos(), t.getAnnotation());
                            continue;
                        }
                        if (!t.getType().equals("relSrc")) continue;
                        match.addRelation(t.getStartPos(), t.getEndPos(), t.getTargetStartPos(), t.getTargetEndPos(), t.getAnnotation());
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            match.addError(600, "Unable to read index", e.getLocalizedMessage());
            log.warn(e.getLocalizedMessage());
        }
        return match;
    }

    public Result search(SpanQuery query) {
        Krill krill = new Krill(query);
        krill.getMeta().setSnippets(true);
        return this.search(krill);
    }

    public Result search(SpanQuery query, short count) {
        Krill krill = new Krill(query);
        krill.getMeta().setCount(count);
        krill.getMeta().setSnippets(true);
        return this.search(krill);
    }

    @Deprecated
    public Result search(SpanQuery query, int startIndex, short count, boolean leftTokenContext, short leftContext, boolean rightTokenContext, short rightContext) {
        Krill ks = new Krill(query);
        KrillMeta meta = ks.getMeta();
        meta.setStartIndex(startIndex).setCount(count);
        meta.setContext(new SearchContext(leftTokenContext, leftContext, rightTokenContext, rightContext));
        meta.setSnippets(true);
        return this.search(ks);
    }

    public Result search(Krill ks) {
        boolean snippets;
        this.termContexts = new HashMap();
        KrillCollection collection = ks.getCollection();
        collection.setIndex(this);
        SpanQuery query = ks.getSpanQuery();
        String field = query.getField();
        KrillMeta meta = ks.getMeta();
        Result kr = new Result(query.toString(), meta.getStartIndex(), meta.getCount(), meta.getContext());
        kr.moveNotificationsFrom(ks);
        if (this.getVersion() != null) {
            kr.setVersion(this.getVersion());
        }
        ArrayList fields = (ArrayList)meta.getFields().clone();
        HashSet<String> fieldsSet = new HashSet<String>(fields);
        boolean bl = snippets = meta.hasSnippets() || meta.hasTokens();
        if (fields.contains("@all")) {
            fields = null;
        } else {
            fieldsSet.add(field);
        }
        int i = 0;
        int j = 0;
        int startIndex = kr.getStartIndex();
        short count = kr.getItemsPerPage();
        int hits = kr.getItemsPerPage() + startIndex;
        int limit = meta.getLimit();
        short itemsPerResourceCounter = 0;
        boolean cutoff = meta.doCutOff();
        short itemsPerResource = meta.getItemsPerResource();
        if (limit > 0) {
            if (hits > limit) {
                hits = limit;
            }
            if (limit < startIndex) {
                return kr;
            }
        }
        ArrayList<Match> atomicMatches = new ArrayList<Match>(kr.getItemsPerPage());
        TimeOutThread tthread = new TimeOutThread();
        tthread.start();
        long timeout = meta.getTimeOut();
        boolean isTimeout = false;
        long t1 = System.nanoTime();
        try {
            Object rewrittenQuery = query.rewrite(this.reader());
            while (!((Query)rewrittenQuery).equals(query)) {
                query = (SpanQuery)rewrittenQuery;
                rewrittenQuery = query.rewrite(this.reader());
            }
            for (LeafReaderContext atomic : this.reader().leaves()) {
                int localDocID;
                int oldLocalDocID = -1;
                if (isTimeout) break;
                FixedBitSet bitset = collection.bits(atomic);
                if (bitset.nextSetBit(0) == Integer.MAX_VALUE) continue;
                PositionsToOffset pto = snippets ? new PositionsToOffset(atomic, field) : null;
                Spans spans = query.getSpans(atomic, bitset, this.termContexts);
                LeafReader lreader = atomic.reader();
                while (i < hits && spans.next()) {
                    ++itemsPerResourceCounter;
                    if (tthread.getTime() > timeout) {
                        kr.setTimeExceeded(true);
                        isTimeout = true;
                        break;
                    }
                    localDocID = spans.doc();
                    if (localDocID == oldLocalDocID || oldLocalDocID == -1) {
                        if (itemsPerResource > 0 && itemsPerResourceCounter > itemsPerResource) {
                            if (!spans.skipTo(localDocID + 1)) break;
                            itemsPerResourceCounter = 1;
                            localDocID = spans.doc();
                        }
                    } else {
                        itemsPerResourceCounter = 1;
                    }
                    if (itemsPerResourceCounter == 1) {
                        ++j;
                    }
                    oldLocalDocID = localDocID;
                    if (startIndex <= i) {
                        int docID = atomic.docBase + localDocID;
                        Document doc = fields != null ? lreader.document(localDocID, fieldsSet) : lreader.document(localDocID);
                        Match match = new Match(pto, localDocID, spans.start(), spans.end());
                        if (snippets) {
                            match.setContext(kr.getContext());
                            match.retrievePagebreaks("~:base/s:pb");
                            if (spans.isPayloadAvailable()) {
                                match.addPayload((List)spans.getPayload());
                            }
                            if (meta.hasSnippets()) {
                                match.hasSnippet = true;
                            }
                            if (meta.hasTokens()) {
                                match.hasTokens = true;
                            }
                        }
                        kr.add(match);
                        match.internalDocID = docID;
                        if (fields != null) {
                            match.populateDocument(doc, snippets ? field : null, fields);
                        } else {
                            match.populateDocument(doc, snippets ? field : null);
                        }
                        atomicMatches.add(match);
                    }
                    ++i;
                }
                while (!(cutoff || isTimeout || !spans.next() || limit > 0 && i >= limit)) {
                    if (tthread.getTime() > timeout) {
                        kr.setTimeExceeded(true);
                        isTimeout = true;
                        break;
                    }
                    ++itemsPerResourceCounter;
                    localDocID = spans.doc();
                    if (localDocID == Integer.MAX_VALUE) break;
                    if (localDocID == oldLocalDocID || oldLocalDocID == -1) {
                        if (localDocID == -1) break;
                        if (itemsPerResource > 0 && itemsPerResourceCounter > itemsPerResource) {
                            if (!spans.skipTo(localDocID + 1)) break;
                            itemsPerResourceCounter = 1;
                            localDocID = spans.doc();
                        }
                    } else {
                        itemsPerResourceCounter = 1;
                    }
                    if (itemsPerResourceCounter == 1) {
                        ++j;
                    }
                    oldLocalDocID = localDocID;
                    ++i;
                }
                atomicMatches.clear();
            }
            if (itemsPerResource > 0) {
                kr.setItemsPerResource(itemsPerResource);
            }
            kr.setTotalResults(cutoff ? -1L : (long)i);
            kr.setTotalResources(cutoff ? -1L : (long)j);
        }
        catch (IOException e) {
            kr.addError(600, "Unable to read index", e.getLocalizedMessage());
            log.warn(e.getLocalizedMessage());
        }
        catch (QueryException e) {
            kr.addError(e.getErrorCode(), e.getLocalizedMessage(), new String[0]);
            log.warn(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            kr.addError(104, e.getLocalizedMessage(), new String[0]);
            log.warn(e.getMessage());
        }
        catch (Exception e) {
            kr.addError(100, e.getMessage(), new String[0]);
            log.error(e.getMessage());
            e.printStackTrace();
        }
        tthread.stopTimer();
        kr.setBenchmark(t1, System.nanoTime());
        return kr;
    }

    public MetaFields getFields(String textSigle) {
        ArrayList<String> hs = new ArrayList<String>();
        hs.add("@all");
        return this.getFields(textSigle, hs);
    }

    public MetaFields getFields(String textSigle, List<String> fields) {
        TermQuery textSigleQuery = new TermQuery(new Term("textSigle", textSigle));
        QueryWrapperFilter filter = new QueryWrapperFilter(textSigleQuery);
        if (fields.contains("@all")) {
            fields = null;
        }
        MetaFields metaFields = new MetaFields(textSigle);
        try {
            for (LeafReaderContext atomic : this.reader().leaves()) {
                int localDocID;
                DocIdSet filterSet = ((Filter)filter).getDocIdSet(atomic, atomic.reader().getLiveDocs());
                DocIdSetIterator filterIterator = filterSet.iterator();
                if (filterIterator == null || (localDocID = filterIterator.nextDoc()) == Integer.MAX_VALUE) continue;
                Document doc = atomic.reader().document(localDocID);
                if (fields == null) {
                    metaFields.populateFields(doc);
                } else {
                    metaFields.populateFields(doc, fields);
                }
                return metaFields;
            }
        }
        catch (IOException e) {
            metaFields.addError(600, "Unable to read index", e.getLocalizedMessage());
            log.warn(e.getLocalizedMessage());
        }
        metaFields.addError(630, "Document not found", new String[0]);
        return metaFields;
    }

    public void getValues(String field) {
    }

    public String getFingerprint() {
        if (this.indexRevision != null) {
            return this.indexRevision;
        }
        if (this.reader() == null) {
            return "null";
        }
        String hash = this.reader().getCombinedCoreAndDeletesKey().toString();
        this.indexRevision = Fingerprinter.create(hash);
        return this.indexRevision;
    }

    public MatchCollector collect(Krill ks, MatchCollector mc) {
        KrillCollection collection = ks.getCollection();
        collection.setIndex(this);
        this.termContexts = new HashMap();
        SpanQuery query = ks.getSpanQuery();
        String field = query.getField();
        long t1 = System.nanoTime();
        HashSet<String> fields = new HashSet<String>(1);
        fields.add("UID");
        try {
            Query rewrittenQuery = query.rewrite(this.reader());
            while (rewrittenQuery != query) {
                query = (SpanQuery)rewrittenQuery;
                rewrittenQuery = query.rewrite(this.reader());
            }
            int matchcount = 0;
            int uniqueDocID = -1;
            for (LeafReaderContext atomic : this.reader().leaves()) {
                int previousDocID = -1;
                int oldLocalDocID = -1;
                FixedBitSet bitset = collection.bits(atomic);
                Spans spans = query.getSpans(atomic, bitset, this.termContexts);
                LeafReader lreader = atomic.reader();
                while (spans.next()) {
                    int localDocID = spans.doc();
                    if (previousDocID != localDocID) {
                        String uniqueDocIDString;
                        if (matchcount > 0) {
                            mc.add(uniqueDocID, matchcount);
                            matchcount = 0;
                        }
                        if ((uniqueDocIDString = lreader.document(localDocID, fields).get("UID")) != null) {
                            uniqueDocID = Integer.parseInt(uniqueDocIDString);
                        }
                        previousDocID = localDocID;
                        continue;
                    }
                    ++matchcount;
                }
                if (matchcount <= 0) continue;
                mc.add(uniqueDocID, matchcount);
                matchcount = 0;
            }
            mc.setBenchmark(t1, System.nanoTime());
        }
        catch (IOException e) {
            mc.addError(600, "Unable to read index", e.getLocalizedMessage());
            log.warn(e.getLocalizedMessage());
        }
        catch (QueryException e) {
            mc.addError(e.getErrorCode(), e.getLocalizedMessage(), new String[0]);
            log.warn(e.getLocalizedMessage());
        }
        mc.close();
        return mc;
    }

    public boolean isReaderOpen() {
        return this.readerOpen;
    }

    @Override
    public Set<String> getAllLeafFingerprints() {
        List<LeafReaderContext> leaves = this.reader().leaves();
        HashSet<String> fingerprints = new HashSet<String>(leaves.size() * 2);
        for (LeafReaderContext context : leaves) {
            String fp = Fingerprinter.create(context.reader().getCombinedCoreAndDeletesKey().toString());
            fingerprints.add(fp);
        }
        return fingerprints;
    }

    public List<String> getFieldVector(String field, KrillCollection collection) {
        collection.setIndex(this);
        ArrayList<String> fieldValues = new ArrayList<String>();
        if (field.equals("tokens") || field.equals("base")) {
            return fieldValues;
        }
        try {
            Filter filter = collection.toFilter();
            if (filter != null) {
                for (LeafReaderContext atomic : this.reader().leaves()) {
                    LeafReader lreader = atomic.reader();
                    DocIdSet docids = filter.getDocIdSet(atomic, null);
                    DocIdSetIterator docs = docids == null ? null : docids.iterator();
                    if (docs == null) continue;
                    while (docs.nextDoc() != Integer.MAX_VALUE) {
                        String fieldValue = lreader.document(docs.docID()).get(field);
                        if (fieldValue == null || fieldValue == "") continue;
                        fieldValues.add(fieldValue);
                    }
                }
            } else {
                for (LeafReaderContext atomic : this.reader().leaves()) {
                    LeafReader lreader = atomic.reader();
                    Bits live = lreader.getLiveDocs();
                    for (int i = 0; i < lreader.maxDoc(); ++i) {
                        Document doc;
                        String fieldValue;
                        if (live != null && !live.get(i) || (fieldValue = (doc = lreader.document(i)).get(field)) == null || fieldValue == "") continue;
                        fieldValues.add(fieldValue);
                    }
                }
            }
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
        catch (QueryException e) {
            log.warn(e.getLocalizedMessage());
        }
        return fieldValues;
    }
}

