/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoCloseFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AbstractWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.DifferenceIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IntersectionIterator;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.PrependSequenceIterator;
import net.sf.saxon.type.UType;

public class VennExpressionAdjunct
extends TransmissionAdjunct {
    private Inversion lhsInversion;
    private Inversion rhsInversion;

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        VennExpression exp = (VennExpression)this.getExpression();
        Expression e0 = exp.getLhsExpression();
        Expression e1 = exp.getRhsExpression();
        int operator = exp.getOperator();
        Pattern p0 = VennExpressionAdjunct.makeStreamingPattern(e0, config);
        if (p0 == null) {
            return null;
        }
        Pattern p1 = VennExpressionAdjunct.makeStreamingPattern(e1, config);
        if (p1 == null) {
            return null;
        }
        if (operator == 1) {
            return new UnionPattern(p0, p1);
        }
        if (operator == 24) {
            return new ExceptPattern(p0, p1);
        }
        return new IntersectPattern(p0, p1);
    }

    private static Pattern makeStreamingPattern(Expression e, Configuration config) {
        if (Streamability.getPostureAndSweepIfKnown(e) != null && Streamability.getPosture(e) == Posture.GROUNDED) {
            return null;
        }
        return Streamability.toStreamingPattern(e, config);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        VennExpression exp = (VennExpression)this.getExpression();
        PostureAndSweep ps0 = Streamability.getStreamability(exp.getLhsExpression(), contextInfo, reasons);
        PostureAndSweep ps1 = Streamability.getStreamability(exp.getRhsExpression(), contextInfo, reasons);
        Posture p0 = ps0.getPosture();
        Posture p1 = ps1.getPosture();
        if (ps0.getSweep() == Sweep.FREE_RANGING || ps1.getSweep() == Sweep.FREE_RANGING) {
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
            return ps1;
        }
        if (ps1.equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
            return ps0;
        }
        if (p0.equals((Object)Posture.CLIMBING) && p1.equals((Object)Posture.CLIMBING)) {
            return new PostureAndSweep(p0, Streamability.wider(ps0.getSweep(), ps1.getSweep()));
        }
        if (!(p0 != Posture.STRIDING && p0 != Posture.CRAWLING || p1 != Posture.STRIDING && p1 != Posture.CRAWLING)) {
            return new PostureAndSweep(Posture.CRAWLING, Streamability.wider(ps0.getSweep(), ps1.getSweep()));
        }
        if (reasons != null) {
            reasons.add("Operands of " + Token.tokens[exp.getOperator()] + " expression on line " + exp.getLocation().getLineNumber() + " have mixed posture (" + (Object)((Object)p0) + " | " + (Object)((Object)p1) + ")");
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        boolean bothConsuming;
        VennExpression exp = (VennExpression)this.getExpression();
        Sweep s0 = Streamability.getSweep(exp.getLhsExpression());
        Sweep s1 = Streamability.getSweep(exp.getRhsExpression());
        boolean bl = bothConsuming = s0 == Sweep.CONSUMING && s1 == Sweep.CONSUMING;
        if (bothConsuming) {
            if (this.lhsInversion == null) {
                this.lhsInversion = Inversion.invertExpression(exp.getLhsExpression(), forGrouping);
                this.rhsInversion = Inversion.invertExpression(exp.getRhsExpression(), forGrouping);
            }
            return (watchManager, out, context) -> new Trigger(AnchorPattern.getInstance(), new VennTwoWayFeed(exp, this, out, context, watchManager), context);
        }
        return super.getWatchMaker(forGrouping);
    }

    private static SequenceIterator linkedListIterator(LinkedList<NodeInfo> nodes) {
        return new ListIterator.Of<NodeInfo>(nodes);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        boolean a0consuming;
        VennExpression exp = (VennExpression)this.getExpression();
        Sweep s0 = Streamability.getSweep(exp.getLhsExpression());
        Sweep s1 = Streamability.getSweep(exp.getRhsExpression());
        boolean bothConsuming = s0 == Sweep.CONSUMING && s1 == Sweep.CONSUMING;
        boolean bl = a0consuming = s0 == Sweep.CONSUMING;
        if (bothConsuming) {
            if (this.lhsInversion == null) {
                this.lhsInversion = Inversion.invertExpression(exp.getLhsExpression(), false);
                this.rhsInversion = Inversion.invertExpression(exp.getRhsExpression(), false);
            }
            return new VennTwoWayFeed(exp, this, out, context, watchManager);
        }
        int operator = exp.getOperator();
        if (operator == 1) {
            if (a0consuming) {
                return new SemiStreamedUnionFeed(exp, exp.getRhsExpression(), out, context);
            }
            return new SemiStreamedUnionFeed(exp, exp.getLhsExpression(), out, context);
        }
        if (operator == 23) {
            return new FilteringFeed(watchManager, out, context, FilteringFeed.OpaqueFilter);
        }
        if (operator == 24) {
            if (a0consuming) {
                return new FilteringFeed(watchManager, out, context, FilteringFeed.TransparentFilter);
            }
            return new FirstOperandOnlyFeed(watchManager, out, context, exp.getLhsExpression());
        }
        throw new UnsupportedOperationException();
    }

    private static class SemiStreamedUnionFeed
    extends ItemFeed {
        Expression nonConsumingOperand;
        SequenceIterator nonConsumingIterator;
        boolean atStart = true;
        boolean emitNonConsumingOperandAtEnd = true;

        public SemiStreamedUnionFeed(Expression exp, Expression nonConsumingOperand, ItemFeed result, XPathContext context) {
            super(exp, result, context);
            this.nonConsumingOperand = nonConsumingOperand;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.nonConsumingIterator = this.nonConsumingOperand.iterate(this.getContext());
        }

        @Override
        public void close() throws XPathException {
            if (this.emitNonConsumingOperandAtEnd) {
                SemiStreamedUnionFeed.processItems(this.nonConsumingIterator, this.getNextOutputter());
            }
            this.getNextOutputter().close();
        }

        @Override
        public void append(Item item) throws XPathException {
            if (this.atStart) {
                NodeInfo first = (NodeInfo)this.nonConsumingIterator.next();
                if (first != null) {
                    if (GlobalOrderComparer.getInstance().compare((NodeInfo)item, first) < 0) {
                        this.nonConsumingIterator = new PrependSequenceIterator(first, this.nonConsumingIterator);
                        this.emitNonConsumingOperandAtEnd = true;
                    } else {
                        this.getNextOutputter().append(first);
                        SemiStreamedUnionFeed.processItems(this.nonConsumingIterator, this.getNextOutputter());
                        this.emitNonConsumingOperandAtEnd = false;
                    }
                } else {
                    this.emitNonConsumingOperandAtEnd = false;
                }
            }
            this.atStart = false;
            this.getNextOutputter().append(item);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.atStart) {
                NodeInfo first = (NodeInfo)this.nonConsumingIterator.next();
                if (first != null) {
                    if (GlobalOrderComparer.getInstance().compare(node, first) < 0) {
                        this.nonConsumingIterator = new PrependSequenceIterator(first, this.nonConsumingIterator);
                        this.emitNonConsumingOperandAtEnd = true;
                    } else {
                        this.getNextOutputter().append(first);
                        SemiStreamedUnionFeed.processItems(this.nonConsumingIterator, this.getNextOutputter());
                        this.emitNonConsumingOperandAtEnd = false;
                    }
                } else {
                    this.emitNonConsumingOperandAtEnd = false;
                }
            }
            this.atStart = false;
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    private static class FirstOperandOnlyFeed
    extends FilteringFeed {
        Expression lhs;

        public FirstOperandOnlyFeed(WatchManager watchManager, ItemFeed out, XPathContext context, Expression lhs) {
            super(watchManager, out, context, FilteringFeed.OpaqueFilter);
            this.lhs = lhs;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            FirstOperandOnlyFeed.processItems(this.lhs.iterate(this.getContext()), this.getNextOutputter());
        }
    }

    private static class CombiningExceptFeed
    extends CombiningFeed {
        private final LinkedList<NodeInfo> lhsBuffer = new LinkedList();
        private final LinkedList<NodeInfo> rhsBuffer = new LinkedList();
        public NodeInfo latestRhsNode = null;
        public boolean emitted;
        public final WatchManager watchManager;

        CombiningExceptFeed(VennExpression exp, ItemFeed result, XPathContext context, WatchManager watchManager) {
            super(exp, result, context);
            this.watchManager = watchManager;
        }

        @Override
        public Receiver startSelectedParentNode(final FleetingParentNode node, Location location) throws XPathException {
            if (this.currentLabel == 0) {
                AbstractWatch lastChanceWatch = new AbstractWatch(){

                    @Override
                    public boolean matchesNode(FleetingNode node2, XPathContext context) throws XPathException {
                        return true;
                    }

                    @Override
                    public boolean matchesNodesOfKind(UType kind) {
                        return true;
                    }

                    @Override
                    public void setAnchorNode(FleetingParentNode anchor) {
                    }

                    @Override
                    public FleetingParentNode getAnchorNode() {
                        return node;
                    }

                    @Override
                    public Receiver startSelectedParentNode(FleetingParentNode node2, Location locationId) throws XPathException {
                        emitted = false;
                        watchManager.removeWatch(this);
                        if (node2 != latestRhsNode) {
                            emitted = true;
                            return this.getResultFeed().startSelectedParentNode(node2, locationId);
                        }
                        return null;
                    }

                    @Override
                    public void endSelectedParentNode(Location locationId) {
                    }
                };
                this.watchManager.addWatch(lastChanceWatch, true);
            } else {
                this.latestRhsNode = node;
            }
            return null;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            if (this.currentLabel == 0 && this.emitted) {
                this.getResultFeed().endSelectedParentNode(locationId);
                this.emitted = false;
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            if (this.currentLabel == 0) {
                boolean exclude = false;
                while (!this.rhsBuffer.isEmpty()) {
                    NodeInfo next = this.rhsBuffer.peekFirst();
                    int c = next.compareOrder((NodeInfo)item);
                    if (c < 0) {
                        this.rhsBuffer.pollFirst();
                        continue;
                    }
                    if (c != 0) break;
                    exclude = true;
                    break;
                }
                if (!exclude) {
                    this.lhsBuffer.add((NodeInfo)item);
                }
            } else {
                while (!this.lhsBuffer.isEmpty()) {
                    NodeInfo next = this.lhsBuffer.peekFirst();
                    int c = next.compareOrder((NodeInfo)item);
                    if (c < 0) {
                        this.getResultFeed().append(this.lhsBuffer.pollFirst());
                        continue;
                    }
                    if (c != 0) break;
                    this.lhsBuffer.pollFirst();
                    break;
                }
                this.rhsBuffer.add((NodeInfo)item);
            }
        }

        @Override
        public void close() throws XPathException {
            DifferenceIterator union = new DifferenceIterator(VennExpressionAdjunct.linkedListIterator(this.lhsBuffer), VennExpressionAdjunct.linkedListIterator(this.rhsBuffer), LocalOrderComparer.getInstance());
            CombiningExceptFeed.processItems(union, this.getResultFeed());
            super.close();
        }
    }

    private static class CombiningIntersectFeed
    extends CombiningFeed {
        private NodeInfo previousNode = null;
        private final Stack<Boolean> duplicates = new Stack();
        private final LinkedList<NodeInfo> lhsBuffer = new LinkedList();
        private final LinkedList<NodeInfo> rhsBuffer = new LinkedList();

        CombiningIntersectFeed(VennExpression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            boolean duplicate = this.previousNode != null && node.isSameNodeInfo(this.previousNode);
            this.previousNode = node;
            this.duplicates.push(duplicate);
            if (duplicate) {
                return this.getResultFeed().startSelectedParentNode(node, locationId);
            }
            return null;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            boolean duplicate = this.duplicates.pop();
            if (duplicate) {
                this.getResultFeed().endSelectedParentNode(locationId);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            LinkedList<NodeInfo> thatBuffer;
            LinkedList<NodeInfo> thisBuffer = this.currentLabel == 0 ? this.lhsBuffer : this.rhsBuffer;
            LinkedList<NodeInfo> linkedList = thatBuffer = this.currentLabel == 0 ? this.rhsBuffer : this.lhsBuffer;
            while (!thatBuffer.isEmpty()) {
                NodeInfo next = thatBuffer.peekFirst();
                int c = next.compareOrder((NodeInfo)item);
                if (c < 0) {
                    thatBuffer.pollFirst();
                    continue;
                }
                if (c != 0) break;
                this.getResultFeed().append(item);
                thatBuffer.pollFirst();
            }
            thisBuffer.add((NodeInfo)item);
        }

        @Override
        public void close() throws XPathException {
            IntersectionIterator union = new IntersectionIterator(VennExpressionAdjunct.linkedListIterator(this.lhsBuffer), VennExpressionAdjunct.linkedListIterator(this.rhsBuffer), LocalOrderComparer.getInstance());
            CombiningIntersectFeed.processItems(union, this.getResultFeed());
            super.close();
        }
    }

    private static class CombiningUnionFeed
    extends CombiningFeed {
        private NodeInfo previousNode = null;
        private final Stack<Boolean> duplicates = new Stack();
        private final LinkedList<NodeInfo> lhsBuffer = new LinkedList();
        private final LinkedList<NodeInfo> rhsBuffer = new LinkedList();

        CombiningUnionFeed(VennExpression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            boolean duplicate;
            boolean bl = duplicate = this.previousNode != null && node.isSameNodeInfo(this.previousNode);
            if (!duplicate) {
                this.getResultFeed().startSelectedParentNode(node, locationId);
                this.previousNode = node;
            }
            this.duplicates.push(duplicate);
            return null;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            boolean duplicate = this.duplicates.pop();
            if (!duplicate) {
                this.getResultFeed().endSelectedParentNode(locationId);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            LinkedList<NodeInfo> thatBuffer;
            LinkedList<NodeInfo> thisBuffer = this.currentLabel == 0 ? this.lhsBuffer : this.rhsBuffer;
            LinkedList<NodeInfo> linkedList = thatBuffer = this.currentLabel == 0 ? this.rhsBuffer : this.lhsBuffer;
            while (!thatBuffer.isEmpty()) {
                NodeInfo next = thatBuffer.peekFirst();
                int c = next.compareOrder((NodeInfo)item);
                if (c < 0) {
                    this.getResultFeed().append(thatBuffer.pollFirst());
                    continue;
                }
                if (c != 0) break;
                thatBuffer.pollFirst();
            }
            thisBuffer.add((NodeInfo)item);
        }

        @Override
        public void close() throws XPathException {
            UnionEnumeration union = new UnionEnumeration(VennExpressionAdjunct.linkedListIterator(this.lhsBuffer), VennExpressionAdjunct.linkedListIterator(this.rhsBuffer), LocalOrderComparer.getInstance());
            CombiningUnionFeed.processItems(union, this.getResultFeed());
            super.close();
        }
    }

    static abstract class CombiningFeed
    extends ItemFeed {
        protected int currentLabel;

        public CombiningFeed(Expression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        void setLabel(int label) {
            this.currentLabel = label;
        }
    }

    private static class VennTwoWayFeed
    extends ItemFeed {
        private final VennExpressionAdjunct streamer;
        private final WatchManager watchManager;
        private CombiningFeed combiner;

        VennTwoWayFeed(VennExpression exp, VennExpressionAdjunct streamer, ItemFeed result, XPathContext context, WatchManager watchManager) {
            super(exp, result, context);
            this.streamer = streamer;
            this.watchManager = watchManager;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            VennExpression exp = (VennExpression)this.getExpression();
            switch (exp.getOperator()) {
                case 1: {
                    this.combiner = new CombiningUnionFeed(exp, this.getResultFeed(), this.getContext());
                    break;
                }
                case 23: {
                    this.combiner = new CombiningIntersectFeed(exp, this.getResultFeed(), this.getContext());
                    break;
                }
                case 24: {
                    this.combiner = new CombiningExceptFeed(exp, this.getResultFeed(), this.getContext(), this.watchManager);
                    break;
                }
                default: {
                    this.combiner = null;
                }
            }
            this.watchManager.addWatch(this.streamer.lhsInversion.getWatch(this.watchManager, new LabellingFeed(this.combiner, this.getContext(), 0), this.getContext()), true);
            this.watchManager.addWatch(this.streamer.rhsInversion.getWatch(this.watchManager, new LabellingFeed(this.combiner, this.getContext(), 1), this.getContext()), true);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
        }

        @Override
        public void append(Item item) throws XPathException {
        }

        @Override
        public void close() throws XPathException {
            this.combiner.close();
        }
    }

    private static class LabellingFeed
    extends NoCloseFeed {
        private final int label;

        public LabellingFeed(CombiningFeed resultFeed, XPathContext context, int label) {
            super(resultFeed, context);
            this.label = label;
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            ((CombiningFeed)this.getResultFeed()).setLabel(this.label);
            return super.startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            ((CombiningFeed)this.getResultFeed()).setLabel(this.label);
            super.endSelectedParentNode(locationId);
        }

        @Override
        public void append(Item item) throws XPathException {
            ((CombiningFeed)this.getResultFeed()).setLabel(this.label);
            this.getResultFeed().append(item);
        }
    }
}

