/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class SaxonPreprocess
extends AnnotationParent {
    private Assertion action = null;
    private Assertion reverseAction = null;

    @Override
    protected void prepareAttributes() throws SchemaException {
        XPathExpression expression;
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"action", "id", "reverse", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNamespace = atts.getValue(NamespaceUri.NULL, "xpathDefaultNamespace");
        if (defaultNamespace == null) {
            defaultNamespace = this.getXSDSchema().getXPathDefaultNamespace();
        }
        NamespaceUri defaultNamespaceUri = defaultNamespace.equals("##defaultNamespace") ? this.getURIForPrefix("", true) : (defaultNamespace.equals("##targetNamespace") ? this.getXSDSchema().getTargetNamespace() : (defaultNamespace.equals("##local") ? NamespaceUri.NULL : NamespaceUri.of(defaultNamespace)));
        String xpath = atts.getValue(NamespaceUri.NULL, "action");
        if (xpath == null) {
            this.missingAttribute("action");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this);
        env.setDefaultElementNamespace(defaultNamespaceUri);
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        XPathVariable valueVariable = env.declareVariable(NamespaceUri.NULL, "value");
        XPathEvaluator xpe = new XPathEvaluator(this.getSchema().getConfiguration());
        try {
            xpe.setStaticContext(env);
            expression = xpe.createExpression(xpath);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            try {
                expression = xpe.createExpression("'*error*'");
            }
            catch (XPathException e2) {
                throw new AssertionError((Object)e2.getMessage());
            }
        }
        this.action = new Assertion(this.getSchema().getConfiguration(), expression, valueVariable, null, xpath);
        this.action.setStaticContext(env);
        xpath = atts.getValue(NamespaceUri.NULL, "reverse");
        if (xpath != null) {
            try {
                expression = xpe.createExpression(xpath);
            }
            catch (XPathException err) {
                this.error(err.getMessage());
                try {
                    expression = xpe.createExpression("'*error*'");
                }
                catch (XPathException e2) {
                    throw new AssertionError((Object)e2.getMessage());
                }
            }
            this.reverseAction = new Assertion(this.getSchema().getConfiguration(), expression, valueVariable, null, xpath);
            this.reverseAction.setStaticContext(env);
        }
        this.processId();
    }

    public Assertion getAction() {
        return this.action;
    }

    public Assertion getReverseAction() {
        return this.reverseAction;
    }
}

