/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.List;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SnapshotFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class SnapshotFeed
extends AbsorptionFeed {
    private final WatchManager watchManager;
    private boolean copyAccumulators;

    public static Trigger getWatch(ItemFeed result, Pattern selection, WatchManager wm, XPathContext context) {
        SnapshotFeed action = new SnapshotFeed(wm, result, context);
        action.copyAccumulators = false;
        Trigger watch = new Trigger(selection, action, context);
        watch.setPipelineConfiguration(wm.getPipelineConfiguration());
        return watch;
    }

    public SnapshotFeed(WatchManager watchManager, ItemFeed result, XPathContext context) {
        super(result, context);
        this.watchManager = watchManager;
        this.copyAccumulators = true;
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) throws XPathException {
        return new PendingSnapshotAction(this, sequenceNr, node);
    }

    @Override
    protected Sequence processGroundedItem(Item item) {
        return SnapshotFn.snapshotSingle(item);
    }

    private static class PendingSnapshotAction
    extends AbsorptionFeed.PendingItem {
        public int sequence;
        public BuilderMonitor monitor;
        public List<NodeInfo> ancestorList;
        private final SnapshotFeed feed;

        public PendingSnapshotAction(SnapshotFeed feed, int sequence, FleetingParentNode node) throws XPathException {
            super(sequence);
            this.feed = feed;
            this.sequence = sequence;
            this.ancestorList = SnapshotFn.makeAncestorList(node);
            this.monitor = SnapshotFn.openAncestors(node, this.ancestorList, feed.getContext());
            this.monitor.markNextNode(node.getNodeKind());
        }

        @Override
        public Receiver getGatherer() throws XPathException {
            TinyBuilder builder = (TinyBuilder)this.monitor.getNextReceiver();
            if (this.feed.copyAccumulators) {
                return new CopyOfFeed.AccumulatorCopier(this.feed.watchManager, this.monitor, builder);
            }
            return this.monitor;
        }

        @Override
        public Sequence deliver() throws XPathException {
            SnapshotFn.closeAncestors(this.ancestorList, this.monitor);
            return this.monitor.getMarkedNode();
        }

        @Override
        public void rollback() {
        }
    }
}

