/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.pedigree;

import com.saxonica.xsltextn.pedigree.DelegatingMapItem;
import com.saxonica.xsltextn.pedigree.Pedigree;
import com.saxonica.xsltextn.pedigree.PedigreeArrayItem;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import java.util.ArrayList;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.value.AtomicValue;

public class PedigreeMapItem
extends DelegatingMapItem
implements PedigreeValue {
    private final Pedigree pedigree;

    public PedigreeMapItem(MapItem base) {
        this(base, Pedigree.PEDIGREE_ROOT);
    }

    public PedigreeMapItem(MapItem base, Pedigree pedigree) {
        super(base);
        this.pedigree = pedigree;
    }

    @Override
    public GroundedValue get(AtomicValue key) {
        GroundedValue value = super.get(key);
        if (value instanceof ArrayItem) {
            Pedigree ped = new Pedigree((PedigreeValue)this, key);
            return new PedigreeArrayItem((ArrayItem)value, ped);
        }
        if (value instanceof MapItem) {
            Pedigree ped = new Pedigree((PedigreeValue)this, key);
            return new PedigreeMapItem((MapItem)value, ped);
        }
        return value;
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
        for (KeyValuePair val : super.keyValuePairs()) {
            Pedigree ped = new Pedigree((PedigreeValue)this, val.key);
            GroundedValue newValue = ped.makePedigreeValue(val.value);
            pairs.add(new KeyValuePair(val.key, newValue));
        }
        return pairs;
    }

    @Override
    public Pedigree getPedigree() {
        return this.pedigree;
    }
}

