/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.MultiAccumulatorWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class AccumulatorRegistryEE
extends AccumulatorRegistry {
    public static void registerSelectedAccumulators(WatchManager watchManager, Set<? extends Accumulator> accumulators) throws XPathException {
        if (!accumulators.isEmpty()) {
            HashMap<Accumulator, AccumulatorWatch> watchMap = new HashMap<Accumulator, AccumulatorWatch>();
            for (Accumulator accumulator : accumulators) {
                AccumulatorWatch watch = new AccumulatorWatch(accumulator);
                watch.setPipelineConfiguration(watchManager.getPipelineConfiguration());
                watch.setWatchManager(watchManager);
                watchMap.put(accumulator, watch);
            }
            MultiAccumulatorWatch maw = new MultiAccumulatorWatch(watchMap);
            watchManager.watchAccumulators(maw);
        }
    }

    @Override
    public Sequence getStreamingAccumulatorValue(NodeInfo node, Accumulator accumulator, AccumulatorFn.Phase phase) throws XPathException {
        if (node instanceof FleetingNode) {
            if (!accumulator.isDeclaredStreamable()) {
                throw new XPathException("Cannot get accumulator value for a streamed node unless the accumulator is declared streamable", "XTDE3362");
            }
            FleetingDocumentNode root = (FleetingDocumentNode)node.getRoot();
            MultiAccumulatorWatch maw = root.getMultiAccumulatorWatch();
            AccumulatorWatch accumulatorWatch = null;
            if (maw != null) {
                Map<Accumulator, AccumulatorWatch> watchMap = maw.getAccumulatorMap();
                AccumulatorWatch accumulatorWatch2 = accumulatorWatch = watchMap == null ? null : watchMap.get(accumulator);
            }
            if (accumulatorWatch == null) {
                throw new XPathException("The accumulator " + accumulator.getAccumulatorName().getDisplayName() + " is not in use for the current streamed document (check @use-accumulators)", "XTDE3362");
            }
            if (phase == AccumulatorFn.Phase.BEFORE) {
                if (accumulatorWatch.isBeingComputed(AccumulatorFn.Phase.BEFORE)) {
                    throw new XPathException("Evaluation of accumulator " + accumulator.getAccumulatorName().getDisplayName() + " requires access to its own value", "XTDE3400");
                }
                return accumulatorWatch.getPreDescentValue((FleetingNode)node);
            }
            if (accumulatorWatch.isBeingComputed(AccumulatorFn.Phase.AFTER)) {
                throw new XPathException("Evaluation of accumulator " + accumulator.getAccumulatorName().getDisplayName() + " requires access to its own value", "XTDE3400");
            }
            return accumulatorWatch.getPostDescentValue((FleetingNode)node);
        }
        return null;
    }
}

