/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Map;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.ma.json.XMLToJsonFn;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class XmlToJsonFnStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Pattern selection;
        SystemFunctionCall instruction = (SystemFunctionCall)this.getExpression();
        Expression select = instruction.getArg(0);
        if (select instanceof CardinalityChecker) {
            select = ((CardinalityChecker)select).getBaseExpression();
        }
        if ((selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null)) != null) {
            return (watchManager, out, context) -> {
                ToJsonAction action = new ToJsonAction(this.getExpression(), out, context);
                return new Trigger(selection, action, context);
            };
        }
        return null;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new ToJsonAction(this.getExpression(), out, context);
    }

    private static class ToJsonAction
    extends ItemFeed {
        private JsonReceiver receiver;
        private boolean indenting;
        private boolean foundOneNode;

        public ToJsonAction(Expression functionCall, ItemFeed out, XPathContext context) {
            super(functionCall, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
            XMLToJsonFn target = (XMLToJsonFn)exp.getTargetFunction(this.getContext());
            if (exp.getArity() > 1) {
                MapItem suppliedOptions = (MapItem)exp.getArg(1).evaluateItem(this.getContext());
                Map<String, GroundedValue> options = target.getDetails().optionDetails.processSuppliedOptions(suppliedOptions, this.getContext());
                this.indenting = ((BooleanValue)options.get("indent").head()).getBooleanValue();
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.foundOneNode) {
                XPathException err = new XPathException("Supplied argument to xml-to-json contains more than one node", "XPTY0004");
                this.dynamicError(err);
                return null;
            }
            this.foundOneNode = true;
            this.receiver = new JsonReceiver(this.getPipelineConfiguration(), this.getContext(), this.getNextOutputter().getStringReceiver(false, locationId));
            this.receiver.setIndenting(this.indenting);
            this.receiver.open();
            return this.receiver;
        }

        @Override
        public void append(Item item) throws XPathException {
            throw new AssertionError();
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
        }

        @Override
        public void close() throws XPathException {
            this.receiver.close();
            super.close();
        }
    }
}

