/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class ItemCheckingFeed
extends ItemFeed {
    private final ItemType requiredType;
    private final RoleDiagnostic role;
    private final Configuration config;
    private int level = 0;
    private final boolean allowAnyElement;

    public ItemCheckingFeed(Expression checker, ItemFeed result, XPathContext context) {
        super(checker, result, context);
        this.requiredType = ((ItemChecker)checker).getRequiredType();
        this.role = ((ItemChecker)checker).getRoleLocator();
        this.config = context.getConfiguration();
        Affinity aff = this.config.getTypeHierarchy().relationship(this.requiredType, NodeKindTest.ELEMENT);
        this.allowAnyElement = aff == Affinity.SAME_TYPE || aff == Affinity.SUBSUMES;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.checkItemType(node);
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            this.checkItemType(item);
            this.getNextOutputter().append(item);
        }
    }

    private void checkItemType(Item item) throws XPathException {
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (!this.hasFailed() && !this.requiredType.matches(item, th)) {
            String message = this.role.composeErrorMessage(this.requiredType, item, th);
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                XPathException te = new XPathException(message, errorCode, this.getExpression().getLocation());
                te.setIsTypeError(false);
                this.dynamicError(te);
            } else {
                this.typeError(message, errorCode);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            this.getResultFeed().close();
        }
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.getExpression().getLocation());
        e.setIsTypeError(true);
        this.dynamicError(e);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level++ == 0) {
            this.checkItemType(new FleetingDocumentNode(-1L));
        }
        super.startDocument(properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, Location location, int properties) throws XPathException {
        if (this.level++ == 0 && !this.allowAnyElement) {
            Orphan node = new Orphan(this.config);
            node.setNodeKind((short)1);
            node.setNodeName(elemName);
            node.setTypeAnnotation(type);
            this.checkItemType(node);
        }
        super.startElement(elemName, type, location, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.level++ == 0 && !this.allowAnyElement) {
            Orphan node = new Orphan(this.config);
            node.setNodeKind((short)1);
            node.setNodeName(elemName);
            node.setTypeAnnotation(type);
            this.checkItemType(node);
        }
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        super.endDocument();
    }
}

