/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class GroupStarting
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence input = arguments[0];
        FunctionItem function = (FunctionItem)arguments[1].head();
        return new LazySequence(new GroupStartingFunctionIterator(input.iterate(), function, context));
    }

    private static class GroupStartingFunctionIterator
    implements SequenceIterator {
        private final SequenceIterator baseIterator;
        private final FunctionItem function;
        private final XPathContext context;
        private Item pending = null;
        private boolean finished = false;

        public GroupStartingFunctionIterator(SequenceIterator in, FunctionItem f, XPathContext context) {
            this.baseIterator = in;
            this.function = f;
            this.context = context;
        }

        @Override
        public ArrayItem next() {
            if (this.finished) {
                return null;
            }
            ArrayList<Item> group = new ArrayList<Item>();
            if (this.pending != null) {
                group.add(this.pending);
            }
            try {
                Item item;
                while ((item = this.baseIterator.next()) != null) {
                    Sequence test = this.function.call(this.context, SequenceTool.fromItems(item));
                    boolean match = ExpressionTool.effectiveBooleanValue(test.head());
                    if (match) {
                        this.pending = item;
                        return this.makeSimpleArray(group);
                    }
                    group.add(item);
                }
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
            this.pending = null;
            this.finished = true;
            return this.makeSimpleArray(group);
        }

        private SimpleArrayItem makeSimpleArray(List<Item> group) {
            try {
                return SimpleArrayItem.makeSimpleArrayItem(new ListIterator.Of<Item>(group));
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void close() {
            this.baseIterator.close();
        }
    }
}

