/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer.cmd;

import experimental.analyzer.Analyzer;
import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerTrainer;
import experimental.analyzer.cmd.TreebankAnnotator;
import java.io.Serializable;
import java.util.Collection;
import marmot.util.FileUtils;

public class TreebankTrainer {
    public static void main(String[] args2) {
        String model_type = args2[0];
        String options_string = args2[1];
        String output_file = args2[2];
        String train_file = args2[3];
        Analyzer analyzer = TreebankTrainer.train(model_type, options_string, train_file);
        for (int i = 3; i < args2.length; i += 2) {
            String test_file = args2[i];
            String pred_file = args2[i + 1];
            System.err.println("File:" + test_file);
            TreebankAnnotator.test(analyzer, test_file);
            TreebankAnnotator.annotate(analyzer, test_file, pred_file);
        }
        FileUtils.saveToFile((Serializable)analyzer, output_file);
    }

    public static Analyzer train(String model_type, String options_string, String train_file) {
        AnalyzerTrainer trainer;
        try {
            Class<?> trainer_class = Class.forName(model_type);
            trainer = (AnalyzerTrainer)trainer_class.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        trainer.setOptions(options_string);
        Collection<AnalyzerInstance> training_instances = AnalyzerInstance.getTreebankInstances(train_file);
        Analyzer analyzer = trainer.train(training_instances);
        return analyzer;
    }
}

