/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Aspell
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ASPELL_PATH = "/mounts/Users/cisintern/muellets/cistern/marmot/cmd/marmot_aspell";
    private transient Process process_;
    private transient BufferedReader out_;
    private transient BufferedWriter in_;
    private transient Map<String, Boolean> cache_;
    private String command_line_;
    private String encoding_;

    public Aspell(String marmot_aspell_path, String lang, String encoding) {
        this.encoding_ = encoding;
        this.command_line_ = String.format("%s %s %s", marmot_aspell_path, lang, encoding);
        this.init();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.init();
    }

    private void init() {
        this.cache_ = new HashMap<String, Boolean>();
        try {
            this.process_ = Runtime.getRuntime().exec(this.command_line_);
            this.out_ = new BufferedReader(new InputStreamReader(this.process_.getInputStream()));
            this.in_ = new BufferedWriter(new OutputStreamWriter(this.process_.getOutputStream(), this.encoding_));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean isCorrect(String word) {
        Boolean correct = this.cache_.get(word);
        if (correct != null) {
            return correct;
        }
        try {
            this.in_.write(word);
            this.in_.newLine();
            this.in_.flush();
            while (!this.out_.ready()) {
            }
            String line = this.out_.readLine();
            assert (line != null);
            assert (line.length() == 1);
            char c = line.charAt(0);
            assert (c == '0' || c == '1');
            boolean is_correct = c != '0';
            this.cache_.put(word, is_correct);
            return is_correct;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void shutdown() {
        try {
            this.in_.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

