/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

public class Numerics {
    public static final double EPSILON = 1.0E-5;

    public static boolean approximatelyEqual(double[] array1, double[] array2, double eps) {
        boolean approxEqual = true;
        for (int i = 0; i < array1.length; ++i) {
            if (!(Math.abs(array1[i] - array2[i]) > eps)) continue;
            approxEqual = false;
            break;
        }
        return approxEqual;
    }

    public static boolean approximatelyEqual(double[][] array1, double[][] array2, double eps) {
        boolean approxEqual = true;
        block0: for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[i].length; ++j) {
                if (!(Math.abs(array1[i][j] - array2[i][j]) > eps)) continue;
                approxEqual = false;
                continue block0;
            }
        }
        return approxEqual;
    }

    public static boolean approximatelyEqual(double[][][] array1, double[][][] array2, double eps) {
        boolean approxEqual = true;
        for (int i = 0; i < array1.length; ++i) {
            block1: for (int j = 0; j < array1[i].length; ++j) {
                for (int k = 0; k < array1[i][j].length; ++k) {
                    if (!(Math.abs(array1[i][j][k] - array2[i][j][k]) > eps)) continue;
                    approxEqual = false;
                    continue block1;
                }
            }
        }
        return approxEqual;
    }

    public static double sumLogProb(double a, double b) {
        if (a == Double.NEGATIVE_INFINITY) {
            if (b == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            return b;
        }
        if (b == Double.NEGATIVE_INFINITY) {
            return a;
        }
        if (a > b) {
            return a + Math.log1p(Math.exp(b - a));
        }
        return b + Math.log1p(Math.exp(a - b));
    }

    public static double digamma(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x < 0.0) {
            throw new IllegalArgumentException("x <= 0 : x =" + x);
        }
        double result2 = 0.0;
        while (x < 7.0) {
            result2 -= 1.0 / x;
            x += 1.0;
        }
        double xx = 1.0 / (x -= 0.5);
        double xx2 = xx * xx;
        double xx4 = xx2 * xx2;
        return result2 += Math.log(x) + 0.041666666666666664 * xx2 - 0.007291666666666667 * xx4 + 0.0038442460317460315 * xx4 * xx2 - 0.004134114583333333 * xx4 * xx4;
    }

    public static double exp_digamma(double x) {
        return Math.exp(Numerics.digamma(x));
    }

    public static boolean approximatelyGreaterEqual(double a, double b, double epsilon) {
        return a + epsilon > b;
    }

    public static boolean approximatelyGreaterEqual(double a, double b) {
        return Numerics.approximatelyGreaterEqual(a, b, 1.0E-5);
    }

    public static boolean approximatelyLesserEqual(double a, double b) {
        return Numerics.approximatelyGreaterEqual(b, a);
    }

    public static boolean approximatelyEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }
}

