/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.FieldOrSelector;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.IdentitySelector;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SelectionParser;
import com.saxonica.ee.stream.StreamingPatternMaker;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaException;

public class XSDFieldOrSelector
extends AnnotationParent {
    private FieldOrSelector fieldOrSelector = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        Pattern selector;
        Expression exp;
        boolean isField = this.getLocalPart().equals("field");
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "xpath", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNS = atts.getValue("", "xpathDefaultNamespace");
        if (defaultNS == null) {
            defaultNS = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNS != null) {
            if (defaultNS.equals("##defaultNamespace")) {
                defaultNS = this.getURIForPrefix("", true);
            } else if (defaultNS.equals("##targetNamespace")) {
                defaultNS = this.getXSDSchema().getTargetNamespace();
            } else if (defaultNS.equals("##local")) {
                defaultNS = "";
            }
        } else {
            defaultNS = "";
        }
        String xpath = atts.getValue("", "xpath");
        if (xpath == null) {
            this.missingAttribute("xpath");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this.getConfiguration());
        env.setDefaultElementNamespace(defaultNS);
        try {
            exp = new XPathParser().parse(xpath, 0, 0, env);
            boolean allowExtensions = this.getXSDSchema().getAllowedExtensions().contains("id-xpath-syntax");
            if (allowExtensions) {
                ArrayList<String> reasonsForFailure = new ArrayList<String>();
                selector = StreamingPatternMaker.makeStreamingPattern(exp, this.getConfiguration(), reasonsForFailure);
                if (!reasonsForFailure.isEmpty()) {
                    throw new XPathException((String)reasonsForFailure.get(0));
                }
            } else {
                SelectionParser selectionParser = new SelectionParser();
                selector = selectionParser.parseSelector(xpath, env, isField);
                exp = selectionParser.getOptimizedExpression();
            }
            selector.setLocation(env.getContainingLocation());
            selector.setRetainedStaticContext(env.makeRetainedStaticContext());
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            selector = new NodeTestPattern(ErrorType.getInstance());
            exp = Literal.makeEmptySequence();
        }
        this.processId();
        if (isField) {
            this.fieldOrSelector = new IdentityField(xpath);
            this.fieldOrSelector.setLocator(this);
            this.fieldOrSelector.setSelection(selector);
            this.fieldOrSelector.setSelectExpression(exp);
            this.fieldOrSelector.setNamespaceContext(this.makeNamespaceContext());
            this.fieldOrSelector.setXPathDefaultNamespace(defaultNS);
        } else {
            this.fieldOrSelector = new IdentitySelector(xpath);
            this.fieldOrSelector.setLocator(this);
            this.fieldOrSelector.setSelection(selector);
            this.fieldOrSelector.setSelectExpression(exp);
            this.fieldOrSelector.setNamespaceContext(this.makeNamespaceContext());
            this.fieldOrSelector.setXPathDefaultNamespace(defaultNS);
        }
    }

    public IdentityField getIdentityField() {
        if (this.fieldOrSelector instanceof IdentityField) {
            return (IdentityField)this.fieldOrSelector;
        }
        return null;
    }

    public IdentitySelector getIdentitySelector() {
        if (this.fieldOrSelector instanceof IdentitySelector) {
            return (IdentitySelector)this.fieldOrSelector;
        }
        return null;
    }
}

