/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationDataReader;
import chipmunk.segmenter.SegmentationReading;
import chipmunk.segmenter.Segmenter;
import chipmunk.segmenter.TagSet;
import chipmunk.segmenter.Word;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import marmot.util.FileUtils;

public class Stemmer {
    private Segmenter segmenter_;
    private Mode mode_;

    public Stemmer(Segmenter segmenter, Mode mode) {
        this.segmenter_ = segmenter;
        this.mode_ = mode;
    }

    String stem(Word word) {
        SegmentationReading reading = this.segmenter_.segment(word);
        StringBuilder sb = new StringBuilder();
        Iterator<String> segments = reading.getSegments().iterator();
        Iterator<String> tags = reading.getTags().iterator();
        while (segments.hasNext()) {
            String segment = segments.next();
            String tag = tags.next();
            if (!tag.startsWith("ROOT") && (!tag.startsWith("DERI") || this.mode_ != Mode.STEMMING) && !tag.startsWith("NUM") && !tag.startsWith(TagSet.SPECIAL)) continue;
            sb.append(segment);
        }
        if (sb.length() == 0) {
            return "EMPTY";
        }
        return sb.toString();
    }

    public void stemToFile(String outfile, SegmentationDataReader words) throws IOException {
        Writer writer = FileUtils.openFileWriter(outfile);
        for (Word word : words) {
            String stem = this.stem(word);
            writer.write(word.getWord());
            writer.write(9);
            writer.write(stem);
            writer.write(10);
        }
        writer.close();
    }

    public static enum Mode {
        ROOT_DETECTION,
        STEMMING;

    }
}

