/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class PreprocessFacet
extends Facet {
    Configuration config;
    Assertion action;
    Assertion reverseAction;

    public PreprocessFacet() {
    }

    public PreprocessFacet(Assertion action, Assertion reverseAction) {
        this.action = action;
        this.reverseAction = reverseAction;
    }

    @Override
    public boolean isConstraining() {
        return false;
    }

    @Override
    public String getName() {
        return "preprocess";
    }

    @Override
    public String getValue() {
        return null;
    }

    public Assertion getAction() {
        return this.action;
    }

    public Assertion getReverseAction() {
        return this.reverseAction;
    }

    public void setAction(Assertion action) {
        this.action = action;
    }

    public void setReverseAction(Assertion action) {
        this.reverseAction = action;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
    }

    public CharSequence preprocess(CharSequence input) throws ValidationException {
        XPathExpression exp = this.action.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.action.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getStringValueCS();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    public CharSequence postprocess(CharSequence input) throws ValidationException {
        if (this.reverseAction == null) {
            return input;
        }
        XPathExpression exp = this.reverseAction.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.reverseAction.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getStringValueCS();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.getName());
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        this.action.serialize(serializer);
        if (this.reverseAction != null) {
            this.reverseAction.serialize(serializer);
        }
        serializer.endElement();
    }

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue(PreprocessFacet.this.getName());
                    }
                    case "implementation": {
                        return new ObjectValue<PreprocessFacet>(PreprocessFacet.this);
                    }
                    case "action": {
                        return PreprocessFacet.this.action.getComponentAsFunction();
                    }
                    case "reverse action": {
                        return PreprocessFacet.this.reverseAction.getComponentAsFunction();
                    }
                    case "fixed": {
                        return BooleanValue.get(PreprocessFacet.this.isFixed());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

