/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.config.StandardSchemaResolver;
import com.saxonica.ee.jaxp.SchemaFactoryImpl;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaNodeFactory;
import com.saxonica.ee.schema.sdoc.VersionControlFilter;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Valve;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class SchemaReader {
    private SchemaReader() {
    }

    public static Source getSource(String baseURI, String relativeURI, PipelineConfiguration pipe, String targetNamespace) throws SchemaException {
        try {
            String[] locations = new String[]{relativeURI};
            Source[] sources = null;
            SchemaURIResolver r = pipe.getSchemaURIResolver();
            if (r != null) {
                sources = r.resolve(targetNamespace, baseURI, locations);
            }
            if (sources == null) {
                r = new StandardSchemaResolver((EnterpriseConfiguration)pipe.getConfiguration());
                sources = r.resolve(targetNamespace, baseURI, locations);
            }
            if (sources.length == 0) {
                return null;
            }
            if (sources.length == 1) {
                return sources[0];
            }
            throw new UnsupportedOperationException("SchemaURIResolver is currently restricted to return one source for each schemaLocation");
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static Source[] getSources(String baseURI, String[] relativeURIs, PipelineConfiguration pipe, String targetNamespace) throws SchemaException {
        try {
            Source[] sources = pipe.getSchemaURIResolver().resolve(targetNamespace, baseURI, relativeURIs);
            if (sources == null) {
                StandardSchemaResolver r = new StandardSchemaResolver((EnterpriseConfiguration)pipe.getConfiguration());
                sources = r.resolve(targetNamespace, baseURI, relativeURIs);
            }
            return sources;
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static SchemaDocument read(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        SchemaDocument schemaDocument;
        AxisIterator children;
        NodeInfo top;
        boolean tracing = pipe.getConfiguration().isTiming();
        String docId = source.getSystemId();
        if (docId == null) {
            docId = "(unknown URI)";
        }
        if (tracing) {
            pipe.getConfiguration().getLogger().info("Loading schema document " + docId);
        }
        if ((top = (children = (schemaDocument = SchemaReader.buildSchemaDocument(source, compiler, pipe, referrer)).getDocument().getRootNode().iterateAxis((byte)3, NodeKindTest.makeNodeKindTest(1))).next()).getURI().equals("http://ns.saxonica.com/schema-component-model")) {
            if (tracing) {
                pipe.getConfiguration().getLogger().info("Loaded compiled schema document " + docId);
            }
            return schemaDocument;
        }
        if (!(top instanceof XSDSchema)) {
            SchemaException err = new SchemaException("Outermost element of schema document must be xs:schema");
            ExplicitLocation loc = new ExplicitLocation(source.getSystemId(), top == null ? 1 : top.getLineNumber(), -1);
            err.setLocator(loc);
            pipe.getErrorListener().fatalError(err);
            throw err;
        }
        compiler.setPipelineConfiguration(pipe);
        compiler.setBeingRead(source.getSystemId());
        ((XSDSchema)top).processAllAttributes();
        ((XSDSchema)top).validateSubtree(compiler);
        compiler.markAsRead(source.getSystemId(), (XSDSchema)top);
        int errors = ((XSDSchema)top).getErrorCount();
        if (errors > 0) {
            String msg = errors == 1 ? "One error was" : errors + " errors were";
            throw new SchemaException(msg + " found while processing the schema");
        }
        if (tracing) {
            pipe.getConfiguration().getLogger().info("Finished loading schema document " + source.getSystemId());
        }
        return schemaDocument;
    }

    public static SchemaDocument buildSchemaDocument(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        TreeInfo tree;
        SchemaNodeFactory nodeFactory = new SchemaNodeFactory(compiler, pipe, referrer);
        LinkedTreeBuilder schemaBuilder = new LinkedTreeBuilder(pipe);
        schemaBuilder.setSystemId(source.getSystemId());
        schemaBuilder.setNodeFactory(nodeFactory);
        schemaBuilder.setLineNumbering(true);
        Stripper stripper = new Stripper(AllElementsSpaceStrippingRule.getInstance(), schemaBuilder);
        VersionControlFilter vcFilter = new VersionControlFilter(compiler, stripper);
        StartTagBuffer startTagBuffer = new StartTagBuffer(vcFilter);
        vcFilter.setStartTagBuffer(startTagBuffer);
        startTagBuffer.setUnderlyingReceiver(vcFilter);
        CommentStripper commentStripper = new CommentStripper(startTagBuffer);
        if (source instanceof NodeInfo) {
            String base = ((NodeInfo)source).getBaseURI();
            if (!base.equals(source.getSystemId())) {
                schemaBuilder.setSystemId(base);
            }
            LocationCopier copier = new LocationCopier(((NodeInfo)source).getNodeKind() == 9);
            pipe.setComponent(CopyInformee.class.getName(), copier);
        }
        TinyBuilder scmBuilder = new TinyBuilder(pipe);
        scmBuilder.setSystemId(source.getSystemId());
        Valve valve = new Valve("http://ns.saxonica.com/schema-component-model", commentStripper, scmBuilder);
        Configuration config = pipe.getConfiguration();
        ParseOptions options = new ParseOptions(config.getParseOptions());
        options.setSchemaValidationMode(3);
        options.setErrorListener(compiler.getErrorListener());
        try {
            commentStripper.setPipelineConfiguration(pipe);
            if (Version.platform.isJava() && options.getXMLReader() == null && options.getXMLReaderMaker() == null && !(source instanceof NodeInfo) && !(source instanceof DOMSource)) {
                SchemaReader.setupSourceWithReader(source, compiler, valve, config, options);
            } else if (source instanceof NodeInfo && ((NodeInfo)source).getNodeKind() == 1 || source instanceof DOMSource && ((DOMSource)source).getNode().getNodeType() == 1) {
                TinyBuilder temp = new TinyBuilder(pipe);
                temp.setSystemId(source.getSystemId());
                temp.open();
                temp.startDocument(0);
                Sender.send(source, temp, options);
                temp.endDocument();
                temp.close();
                Sender.send(temp.getCurrentRoot(), valve, options);
            } else {
                Sender.send(source, valve, options);
            }
            tree = valve.wasDiverted() ? scmBuilder.getTree() : schemaBuilder.getCurrentRoot().getTreeInfo();
            schemaBuilder.reset();
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null) {
                if (cause instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)cause;
                    if ((cause = spe.getException()) != null) {
                        if (cause instanceof SchemaException) {
                            throw (SchemaException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            cause.printStackTrace();
                        }
                        throw new SchemaException(cause);
                    }
                    throw new SchemaException("Failed to parse schema document");
                }
                if (cause instanceof SchemaException) {
                    throw (SchemaException)cause;
                }
                throw new SchemaException(cause);
            }
            throw new SchemaException(err);
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                ParseOptions.close(source);
            }
        }
        NodeInfo doc = tree.getRootNode();
        if (doc.iterateAxis((byte)3, NodeKindTest.ELEMENT).next() == null) {
            throw new SchemaException("Schema document is empty or absent");
        }
        return new SchemaDocument(tree);
    }

    public static void setupSourceWithReader(Source source, SchemaCompiler compiler, Valve valve, Configuration config, ParseOptions options) throws XPathException {
        XMLReader parser = config.getStyleParser();
        options.setXMLReader(parser);
        if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
            parser.setEntityResolver(options.getEntityResolver());
        }
        if (compiler.getErrorListener() instanceof SchemaFactoryImpl.ErrorListenerWrappingErrorHandler) {
            parser.setErrorHandler(((SchemaFactoryImpl.ErrorListenerWrappingErrorHandler)compiler.getErrorListener()).getErrorHandler());
        }
        options.setDTDValidationMode(4);
        Sender.send(source, valve, options);
        config.reuseStyleParser(parser);
    }
}

