/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.registry.XPath31HOFunctionSet;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;

public class Evaluate
extends SystemFunction {
    protected IndependentContext makeStaticContext(XPathContext context, NodeInfo namespaceOrigin, String baseUri) {
        RetainedStaticContext rsc = this.getRetainedStaticContext();
        Configuration config = context.getConfiguration();
        IndependentContext env = new IndependentContext(config);
        env.setBaseURI(baseUri);
        env.setExecutable(context.getController().getExecutable());
        env.setXPathLanguageLevel(31);
        if (namespaceOrigin != null) {
            env.setNamespaces(namespaceOrigin);
        } else {
            env.setNamespaceResolver(rsc);
            env.setDefaultElementNamespace(rsc.getDefaultElementNamespace());
        }
        FunctionLibraryList libraryList0 = context.getController().getExecutable().getFunctionLibrary();
        FunctionLibraryList libraryList1 = new FunctionLibraryList();
        for (FunctionLibrary lib : libraryList0.getLibraryList()) {
            if (lib instanceof BuiltInFunctionSet && ((BuiltInFunctionSet)lib).getNamespace().equals("http://www.w3.org/2005/xpath-functions")) {
                libraryList1.addFunctionLibrary(XPath31HOFunctionSet.getInstance());
                continue;
            }
            libraryList1.addFunctionLibrary(lib);
        }
        env.setFunctionLibrary(libraryList1);
        env.setDecimalFormatManager(this.getRetainedStaticContext().getDecimalFormatManager());
        return env;
    }

    protected PreparedExpression prepareExpression(String exprText, NodeInfo namespaceOrigin, String baseUri, String functionName, XPathContext context) throws XPathException {
        Expression expr;
        Configuration config = context.getConfiguration();
        IndependentContext env = this.makeStaticContext(context, namespaceOrigin, baseUri);
        Executable exec = context.getController().getExecutable();
        env.setExecutable(exec);
        env.setXPathLanguageLevel(30);
        env.setFunctionLibrary(exec.getFunctionLibrary());
        env.setAllowUndeclaredVariables(true);
        PreparedExpression pexpr = new PreparedExpression();
        pexpr.expStaticContext = env;
        pexpr.variables = new XPathVariable[10];
        for (int i = 1; i < 10; ++i) {
            pexpr.variables[i - 1] = env.declareVariable("", "p" + i);
        }
        try {
            expr = ExpressionTool.make(exprText, env, 0, 0, null);
        }
        catch (XPathException e) {
            XPathException err = new XPathException("Static error in XPath expression supplied to " + functionName + ": " + e.getMessage().trim());
            err.setErrorCodeQName(e.getErrorCodeQName());
            err.setXPathContext(context);
            throw err;
        }
        AnyItemType contextItemType = AnyItemType.getInstance();
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        expr = ExpressionTool.resolveCallsToCurrentFunction(expr);
        expr = expr.typeCheck(visitor, config.makeContextItemStaticInfo(contextItemType, true));
        pexpr.stackFrameMap = env.getStackFrameMap();
        ExpressionTool.allocateSlots(expr, pexpr.stackFrameMap.getNumberOfVariables(), pexpr.stackFrameMap);
        pexpr.expression = expr;
        return pexpr;
    }

    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        XPathContextMajor c2 = context.newCleanContext();
        String exprText = arguments[0].head().getStringValue();
        PreparedExpression pexpr = this.prepareExpression(exprText, null, this.getStaticBaseUriString(), "saxon:evaluate", c2);
        c2.setOrigin(pexpr);
        c2.openStackFrame(pexpr.stackFrameMap);
        for (int i = 1; i < arguments.length; ++i) {
            int slot = pexpr.variables[i - 1].getLocalSlotNumber();
            c2.setLocalVariable(slot, arguments[i].materialize());
        }
        c2.setCurrentIterator(context.getCurrentIterator());
        return SequenceTool.toLazySequence(pexpr.expression.iterate(c2));
    }

    public static class PreparedExpression
    implements ContextOriginator {
        public IndependentContext expStaticContext;
        public Expression expression;
        public XPathVariable[] variables;
        public SlotManager stackFrameMap;
    }
}

