/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.validate.CompactStringValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class EnumerationFacetSet
extends Facet {
    private HashMap<Comparable, AtomicSequence> typedValues = new HashMap(20);
    private List<String> stringValues = new ArrayList<String>(20);

    @Override
    public String getName() {
        return "enumeration";
    }

    public List<String> getStringValues() {
        return this.stringValues;
    }

    public void addEnumerationValue(AtomicSequence val, String stringValue) {
        if (val instanceof StringValue) {
            val = new CompactStringValue(val.getStringValue());
        }
        this.typedValues.put(val.getSchemaComparable(), val);
        this.stringValues.add(stringValue);
    }

    @Override
    public String getValue() {
        FastStringBuffer sb = new FastStringBuffer(64);
        for (AtomicSequence v : this.typedValues.values()) {
            sb.append(v.getStringValue());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) {
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return this.typedValues.containsKey(value.getSchemaComparable());
    }

    @Override
    public boolean testListValue(AtomicSequence value) {
        return this.typedValues.containsKey(value.getSchemaComparable());
    }

    public String getSharedInstance(String value) {
        for (String s : this.stringValues) {
            if (!s.equals(value)) continue;
            return s;
        }
        return value;
    }

    public AtomicSequence getSharedInstance(AtomicSequence value) {
        return this.typedValues.get(value.getSchemaComparable());
    }

    @Override
    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        for (AtomicSequence v : this.typedValues.values()) {
            serializer.startElement("enumeration");
            boolean namespaceSensitive = false;
            for (AtomicValue av : v) {
                if (!(av instanceof QualifiedNameValue)) continue;
                String prefix = ((QualifiedNameValue)av).getPrefix();
                String uri = ((QualifiedNameValue)av).getNamespaceURI();
                serializer.declareNamespace(prefix, uri);
                namespaceSensitive = true;
            }
            serializer.emitAttribute("value", v.getStringValue());
            if (namespaceSensitive) {
                serializer.emitAttribute("namespaceSensitive", "true");
            }
            serializer.endElement();
        }
    }

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<EnumerationFacetSet>(this);
                }
                case "value": {
                    ArrayList<StringValue> list = new ArrayList<StringValue>();
                    for (String s : this.stringValues) {
                        list.add(new StringValue(s));
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "typed-value": {
                    ArrayList members = new ArrayList(this.typedValues.values());
                    return new SimpleArrayItem(members);
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

