/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ByteCodeMonitor;
import com.saxonica.ee.bytecode.util.CompilerService;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class ByteCodeCandidate
extends UnaryExpression
implements TailCallReturner {
    public static int GENERATED_COUNTER = 0;
    public static long GENERATION_TIMER = 0L;
    private String objectName;
    private long countDown = 100L;
    private ExpressionOwner owner;
    private NamespaceResolver namespaceResolver = null;
    private Expression targetExpression = null;
    private int id;
    private ByteCodeMonitor byteCodeMonitor;
    private static int nextId = 0;
    private int requiredEvaluationModes;
    public int compiledMode;

    public ByteCodeCandidate(ExpressionOwner owner, Expression child, String objectName, int requiredEvaluationModes) {
        super(child);
        this.owner = owner;
        this.objectName = objectName;
        this.id = nextId++;
        this.requiredEvaluationModes = requiredEvaluationModes;
    }

    public int getId() {
        return this.id;
    }

    public void setCountDown(int val) {
        this.countDown = val;
    }

    public long getCountDown() {
        return this.countDown;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public void setByteCodeMonitor(ByteCodeMonitor monitor) {
        this.byteCodeMonitor = monitor;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (visitor.isOptimizeForStreaming()) {
            return this.getBaseExpression().optimize(visitor, contextInfo);
        }
        return super.optimize(visitor, contextInfo);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        this.getBaseExpression().export(out);
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getBaseExpression().isVacuousExpression();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getBaseExpression().isUpdatingExpression();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        this.getBaseExpression().evaluatePendingUpdates(context, pul);
    }

    @Override
    public int getImplementationMethod() {
        return this.getBaseExpression().getImplementationMethod();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ByteCodeCandidate t = new ByteCodeCandidate(this.owner, this.getBaseExpression().copy(rebindings), this.objectName, this.requiredEvaluationModes);
        ExpressionTool.copyLocationInfo(this, t);
        t.namespaceResolver = this.namespaceResolver;
        t.setByteCodeMonitor(this.byteCodeMonitor);
        return t;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Expression body = this.targetExpression(context, 32);
        if (this.byteCodeMonitor != null) {
            long time = System.nanoTime();
            boolean b = body.effectiveBooleanValue(context);
            time = System.nanoTime() - time;
            this.byteCodeMonitor.logExecution(this, "ebv", time);
            return b;
        }
        return body.effectiveBooleanValue(context);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Expression body = this.targetExpression(context, 4);
        try {
            if (this.byteCodeMonitor != null) {
                long time = System.nanoTime();
                body.process(context);
                time = System.nanoTime() - time;
                this.byteCodeMonitor.logExecution(this, "process", time);
            } else {
                body.process(context);
            }
        }
        catch (XPathException e) {
            e.maybeSetFailingExpression(this);
            e.maybeSetContext(context);
            throw e;
        }
        catch (Exception e2) {
            Location loc = this.getLocation();
            String message = "Internal error evaluating template rule " + (loc.getLineNumber() > 0 ? " at line " + loc.getLineNumber() : "") + (loc.getSystemId() != null ? " in module " + loc.getSystemId() : "");
            e2.printStackTrace();
            throw new RuntimeException(message, e2);
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Expression body = this.targetExpression(context, 4);
        if (body instanceof TailCallReturner) {
            if (this.byteCodeMonitor != null) {
                long time = System.nanoTime();
                TailCall tc = ((TailCallReturner)((Object)body)).processLeavingTail(context);
                if (tc != null) {
                    this.countDown = Integer.MAX_VALUE;
                    return tc;
                }
                time = System.nanoTime() - time;
                this.byteCodeMonitor.logExecution(this, "process", time);
                return null;
            }
            TailCall tc = ((TailCallReturner)((Object)body)).processLeavingTail(context);
            if (tc != null) {
                this.countDown = Integer.MAX_VALUE;
            }
            return tc;
        }
        this.process(context);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression targetExpression(XPathContext context, int evaluationMethods) {
        if (this.targetExpression != null) {
            return this.targetExpression;
        }
        if (context instanceof EarlyEvaluationContext) {
            return this.getBaseExpression();
        }
        if (--this.countDown <= 0L) {
            ByteCodeCandidate byteCodeCandidate = this;
            synchronized (byteCodeCandidate) {
                if (this.targetExpression != null) {
                    return this.targetExpression;
                }
                evaluationMethods |= this.requiredEvaluationModes;
                Configuration config = context.getConfiguration();
                long startTime = 0L;
                if (this.byteCodeMonitor != null) {
                    startTime = System.nanoTime();
                    config.getLogger().info("Generating hotspot byte code (" + this.evaluationMethodName(evaluationMethods) + ") for {" + this.getBaseExpression().toShortString() + "} at " + this.getBaseExpression().getLocation().getSystemId() + "#" + this.getBaseExpression().getLocation().getLineNumber());
                    this.compiledMode = evaluationMethods;
                }
                Optimizer opt = config.obtainOptimizer();
                int lang = this.getPackageData().getHostLanguage();
                CompilerService compilerService = (CompilerService)config.makeCompilerService(lang);
                Expression body = this.getBaseExpression();
                Expression temp = opt.compileToByteCode(compilerService, body, body.getExpressionName(), evaluationMethods);
                if (this.byteCodeMonitor != null) {
                    long totalTime = System.nanoTime() - startTime;
                    this.byteCodeMonitor.logCompilation(this, totalTime);
                }
                this.targetExpression = temp != null ? temp : body;
            }
            return this.targetExpression;
        }
        return this.getBaseExpression();
    }

    private String evaluationMethodName(int method) {
        String s = "";
        if ((method & 0x20) != 0) {
            s = s + "EBV ";
        }
        if ((method & 1) != 0) {
            s = s + "EVAL ";
        }
        if ((method & 2) != 0) {
            s = s + "ITER ";
        }
        if ((method & 4) != 0) {
            s = s + "PROC ";
        }
        return s.trim();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Expression body = this.targetExpression(context, 1);
        if (this.byteCodeMonitor != null) {
            long time = System.nanoTime();
            Item<?> it = body.evaluateItem(context);
            time = System.nanoTime() - time;
            this.byteCodeMonitor.logExecution(this, "eval", time);
            return it;
        }
        return body.evaluateItem(context);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext context) throws XPathException {
        Expression body = this.targetExpression(context, 2);
        if (this.byteCodeMonitor != null) {
            long time = System.nanoTime();
            SequenceIterator<?> iter = body.iterate(context);
            time = System.nanoTime() - time;
            this.byteCodeMonitor.logExecution(this, "iterate", time);
            return iter;
        }
        return body.iterate(context);
    }

    @Override
    public String getExpressionName() {
        return "bytecode";
    }
}

