/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.GeneralPatternOptimizer;
import com.saxonica.ee.trans.NumericComparisonOperand;
import com.saxonica.ee.trans.PatternOptimizer;
import com.saxonica.ee.trans.Precondition;
import com.saxonica.ee.trans.RuleEE;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;

public class IntEqualityPatternOptimizer
extends PatternOptimizer {
    private static IntEqualityPatternOptimizer THE_INSTANCE = new IntEqualityPatternOptimizer();

    public static IntEqualityPatternOptimizer getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public boolean appliesTo(Pattern pattern) {
        if (pattern instanceof PatternWithPredicate) {
            Expression exp = ((PatternWithPredicate)((Object)pattern)).getPredicate();
            return exp instanceof CompareToIntegerConstant;
        }
        return false;
    }

    @Override
    public void process(RuleEE rule, Pattern pattern, Map<Precondition, List<RuleEE>> preconditions, Map<Characteristic, Characteristic> characteristics) {
        Expression exp = ((PatternWithPredicate)((Object)pattern)).getPredicate();
        Expression lhs = ((CompareToIntegerConstant)exp).getLhsExpression();
        NumericComparisonOperand chic = new NumericComparisonOperand(lhs);
        chic = (NumericComparisonOperand)this.allocateCharacteristic(characteristics, chic);
        long key = ((CompareToIntegerConstant)exp).getComparand();
        Precondition.NumericComparisonPrecondition p = new Precondition.NumericComparisonPrecondition(chic, key);
        this.addPrecondition(rule, preconditions, p);
        if (pattern instanceof BasePatternWithPredicate) {
            Pattern base = ((BasePatternWithPredicate)pattern).getBasePattern();
            GeneralPatternOptimizer.getInstance().process(rule, base, preconditions, characteristics);
        }
    }
}

