/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.StringValue;

public class AtomicSequenceConverterCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression operand = ((AtomicSequenceConverter)expression).getBaseExpression();
        Converter converter = ((AtomicSequenceConverter)expression).getConverter();
        if (converter == null) {
            converter = ((AtomicSequenceConverter)expression).allocateConverter(compiler.getConfiguration(), false);
        }
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-Item");
        AtomicSequenceConverterCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo end = methodInfo.newLabel("endASC");
        compiler.compileToItem(operand);
        AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-Item-Returned");
        if (Cardinality.allowsZero(operand.getCardinality())) {
            LabelInfo notNull = methodInfo.newLabel("notNullASC");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
        }
        if (converter instanceof Converter.ToStringConverter) {
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
        } else {
            AtomicSequenceConverterCompiler.allocateStatic(compiler, converter);
            ga.swap();
            ga.checkClass(AtomicValue.class);
            ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        if (requiredClass == String.class || requiredClass == CharSequence.class) {
            LabelInfo handleEmpty;
            TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
            Expression operand = ((AtomicSequenceConverter)expression).getBaseExpression();
            Generator ga = compiler.getCurrentGenerator();
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-Item");
            AtomicSequenceConverterCompiler.visitLineNumber(compiler, ga, expression);
            int operandType = operand.getItemType().getPrimitiveType();
            OnEmpty oe2 = onEmpty;
            boolean needToHandleEmpty = Cardinality.allowsZero(operand.getCardinality()) && !(oe2 instanceof OnEmpty.UnwindAndJump);
            LabelInfo labelInfo = handleEmpty = needToHandleEmpty ? methodInfo.newLabel("handleEmpty") : null;
            if (operandType == 533 && compiler.isInRangeForInt(operand)) {
                oe2 = this.prepareForEmptiness(oe2, needToHandleEmpty, handleEmpty);
                compiler.compileToPrimitive(operand, Integer.TYPE, oe2);
                ga.invokeStaticMethod(Integer.class, "toString", Integer.TYPE);
                this.postpareForEmptiness(onEmpty, ga, methodInfo, needToHandleEmpty, handleEmpty);
            } else if (operandType == 533 && compiler.isInRangeForLong(operand)) {
                oe2 = this.prepareForEmptiness(oe2, needToHandleEmpty, handleEmpty);
                compiler.compileToPrimitive(operand, Long.TYPE, oe2);
                ga.invokeStaticMethod(Long.class, "toString", Long.TYPE);
                this.postpareForEmptiness(onEmpty, ga, methodInfo, needToHandleEmpty, handleEmpty);
            } else if (operandType == 517) {
                oe2 = this.prepareForEmptiness(oe2, needToHandleEmpty, handleEmpty);
                compiler.compileToPrimitive(operand, Double.TYPE, oe2);
                ga.invokeStaticMethod(DoubleValue.class, "doubleToString", Double.TYPE);
                this.postpareForEmptiness(onEmpty, ga, methodInfo, needToHandleEmpty, handleEmpty);
            } else if (operandType == 516) {
                oe2 = this.prepareForEmptiness(oe2, needToHandleEmpty, handleEmpty);
                compiler.compileToPrimitive(operand, Float.TYPE, oe2);
                ga.invokeStaticMethod(FloatValue.class, "floatToString", Float.TYPE);
                this.postpareForEmptiness(onEmpty, ga, methodInfo, needToHandleEmpty, handleEmpty);
            } else if (operandType == 513 || operandType == 631) {
                compiler.compileToPrimitive(operand, requiredClass, onEmpty);
            } else {
                LabelInfo end = methodInfo.newLabel("endASC");
                compiler.compileToItem(operand);
                AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-Item-Returned");
                if (Cardinality.allowsZero(operand.getCardinality())) {
                    LabelInfo notNull = methodInfo.newLabel("notNullASC");
                    ga.dup();
                    ga.ifNonNull(notNull.label());
                    AtomicSequenceConverterCompiler.handleEmptyStringResult(onEmpty, ga, methodInfo, end);
                    methodInfo.placeLabel(notNull);
                }
                ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
                if (requiredClass == String.class) {
                    ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
                }
                methodInfo.placeLabel(end);
            }
        } else {
            super.compileToPrimitive(compiler, expression, requiredClass, onEmpty);
        }
    }

    private OnEmpty prepareForEmptiness(OnEmpty oe2, boolean needToHandleEmpty, LabelInfo handleEmpty) {
        if (needToHandleEmpty) {
            oe2 = new OnEmpty.UnwindAndJump(handleEmpty);
        }
        return oe2;
    }

    private void postpareForEmptiness(OnEmpty onEmpty, Generator ga, GeneratedMethodInfo methodInfo, boolean needToHandleEmpty, LabelInfo handleEmpty) {
        if (needToHandleEmpty) {
            LabelInfo exit = methodInfo.newLabel("exit");
            ga.goTo(exit);
            methodInfo.placeLabel(handleEmpty);
            if (onEmpty instanceof OnEmpty.ReturnEmptyString) {
                ga.push("");
            } else if (onEmpty instanceof OnEmpty.ReturnNull) {
                ga.pushNull();
            } else {
                throw new AssertionError();
            }
            methodInfo.placeLabel(exit);
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression operand = ((AtomicSequenceConverter)expression).getBaseExpression();
        Converter converter = ((AtomicSequenceConverter)expression).getConverter();
        if (converter == null) {
            converter = ((AtomicSequenceConverter)expression).allocateConverter(compiler.getConfiguration(), false);
        }
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-Itr");
        if (converter == Converter.ToStringConverter.INSTANCE) {
            AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-string");
            ga.newInstance(Type.getType(ItemMappingIterator.class));
            ga.dup();
            compiler.compileToIterator(operand);
            AtomicSequenceConverterCompiler.visitLineNumber(compiler, ga, expression);
            ga.getStaticField(AtomicSequenceConverter.class, "TO_STRING_MAPPER", AtomicSequenceConverter.ToStringMappingFunction.class);
            ga.push(true);
            ga.invokeConstructor(ItemMappingIterator.class, SequenceIterator.class, ItemMappingFunction.class, Boolean.TYPE);
        } else {
            AtomicSequenceConverterCompiler.visitAnnotation(compiler, "AtomicSequenceConverterCompiler-1");
            AtomicSequenceConverterCompiler.visitLineNumber(compiler, ga, expression);
            AtomicSequenceConverter.AtomicSequenceMappingFunction amf = new AtomicSequenceConverter.AtomicSequenceMappingFunction();
            amf.setConverter(converter);
            ga.newInstance(Type.getType(ItemMappingIterator.class));
            ga.dup();
            compiler.compileToIterator(operand);
            AtomicSequenceConverterCompiler.allocateStatic(compiler, amf);
            ga.push(true);
            ga.invokeConstructor(ItemMappingIterator.class, SequenceIterator.class, ItemMappingFunction.class, Boolean.TYPE);
        }
    }
}

