/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

public abstract class ComplexNodeEventFeed
extends ItemFeed {
    private Receiver out;
    private boolean open = false;

    public ComplexNodeEventFeed(Expression exp, Feed parentExpressionFeed, XPathContext context) {
        super(exp, parentExpressionFeed, context);
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        if (!this.open) {
            super.open(terminator);
            this.out = this.getResult().getReceiver();
            try {
                this.processLeft(this.getContext());
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
            this.open = true;
        }
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.open && !this.hasFailed()) {
            try {
                return this.getResult().startSelectedParentNode(node, locationId);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        return null;
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (item instanceof FleetingParentNode) {
            throw new XPathException("Internal streaming error: streamed node cannot be used directly to construct output node", "SXST0067", this.getExpression().getLocation());
        }
        if (this.open && !this.hasFailed()) {
            try {
                this.out.append(item);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.open && !this.hasFailed()) {
            try {
                this.getResult().endSelectedParentNode(locationId);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.open && !this.hasFailed()) {
            try {
                this.processRight(this.getContext());
            }
            catch (XPathException e) {
                this.dynamicError(e);
                return;
            }
            super.close();
            this.open = false;
        }
    }

    @Override
    public Receiver getReceiver() {
        return this.out;
    }

    protected void setReceiver(Receiver out) {
        this.out = out;
    }

    protected abstract void processLeft(XPathContext var1) throws XPathException;

    protected abstract void processRight(XPathContext var1) throws XPathException;
}

