/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ThreadInterruptedException;

public class IndexSearcher {
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    protected final LeafSlice[] leafSlices;
    private final ExecutorService executor;
    private static final Similarity defaultSimilarity = new DefaultSimilarity();
    private Similarity similarity = defaultSimilarity;

    public static Similarity getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public IndexSearcher(IndexReader r) {
        this(r, null);
    }

    public IndexSearcher(IndexReader r, ExecutorService executor) {
        this(r.getContext(), executor);
    }

    public IndexSearcher(IndexReaderContext context, ExecutorService executor) {
        assert (context.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader" + context.reader();
        this.reader = context.reader();
        this.executor = executor;
        this.readerContext = context;
        this.leafContexts = context.leaves();
        this.leafSlices = executor == null ? null : this.slices(this.leafContexts);
    }

    public IndexSearcher(IndexReaderContext context) {
        this(context, null);
    }

    protected LeafSlice[] slices(List<LeafReaderContext> leaves) {
        LeafSlice[] slices = new LeafSlice[leaves.size()];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = new LeafSlice(leaves.get(i));
        }
        return slices;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Document doc(int docID) throws IOException {
        return this.reader.document(docID);
    }

    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        this.reader.document(docID, fieldVisitor);
    }

    public Document doc(int docID, Set<String> fieldsToLoad) throws IOException {
        return this.reader.document(docID, fieldsToLoad);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    protected Query wrapFilter(Query query, Filter filter) {
        return filter == null ? query : new FilteredQuery(query, filter);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n) throws IOException {
        return this.search(this.createNormalizedWeight(query), after, n);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, Filter filter, int n) throws IOException {
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), after, n);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.search(query, null, n);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), null, n);
    }

    public void search(Query query, Filter filter, Collector results) throws IOException {
        this.search(this.leafContexts, this.createNormalizedWeight(this.wrapFilter(query, filter)), results);
    }

    public void search(Query query, Collector results) throws IOException {
        this.search(this.leafContexts, this.createNormalizedWeight(query), results);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), n, sort, false, false);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), n, sort, doDocScores, doMaxScore);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, Filter filter, int n, Sort sort) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
        }
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), (FieldDoc)after, n, sort, true, false, false);
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        return this.search(this.createNormalizedWeight(query), n, sort, false, false);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n, Sort sort) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
        }
        return this.search(this.createNormalizedWeight(query), (FieldDoc)after, n, sort, true, false, false);
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, Filter filter, int n, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        if (after != null && !(after instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
        }
        return this.search(this.createNormalizedWeight(this.wrapFilter(query, filter)), (FieldDoc)after, n, sort, true, doDocScores, doMaxScore);
    }

    protected TopDocs search(Weight weight, ScoreDoc after, int nDocs) throws IOException {
        int limit = this.reader.maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        nDocs = Math.min(nDocs, limit);
        if (this.executor == null) {
            return this.search(this.leafContexts, weight, after, nDocs);
        }
        ArrayList<Future<TopDocs>> topDocsFutures = new ArrayList<Future<TopDocs>>(this.leafSlices.length);
        for (int i = 0; i < this.leafSlices.length; ++i) {
            topDocsFutures.add(this.executor.submit(new SearcherCallableNoSort(this, this.leafSlices[i], weight, after, nDocs)));
        }
        TopDocs[] topDocs = new TopDocs[this.leafSlices.length];
        for (int i = 0; i < this.leafSlices.length; ++i) {
            try {
                topDocs[i] = (TopDocs)((Future)topDocsFutures.get(i)).get();
                continue;
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return TopDocs.merge(null, nDocs, topDocs);
    }

    protected TopDocs search(List<LeafReaderContext> leaves, Weight weight, ScoreDoc after, int nDocs) throws IOException {
        int limit = this.reader.maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        nDocs = Math.min(nDocs, limit);
        TopScoreDocCollector collector = TopScoreDocCollector.create(nDocs, after);
        this.search(leaves, weight, (Collector)collector);
        return collector.topDocs();
    }

    protected TopFieldDocs search(Weight weight, int nDocs, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        return this.search(weight, null, nDocs, sort, true, doDocScores, doMaxScore);
    }

    protected TopFieldDocs search(Weight weight, FieldDoc after, int nDocs, Sort sort, boolean fillFields, boolean doDocScores, boolean doMaxScore) throws IOException {
        if (sort == null) {
            throw new NullPointerException("Sort must not be null");
        }
        int limit = this.reader.maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        nDocs = Math.min(nDocs, limit);
        if (this.executor == null) {
            return this.search(this.leafContexts, weight, after, nDocs, sort, fillFields, doDocScores, doMaxScore);
        }
        ArrayList<Future<TopFieldDocs>> topDocsFutures = new ArrayList<Future<TopFieldDocs>>(this.leafSlices.length);
        for (int i = 0; i < this.leafSlices.length; ++i) {
            topDocsFutures.add(this.executor.submit(new SearcherCallableWithSort(this, this.leafSlices[i], weight, after, nDocs, sort, doDocScores, doMaxScore)));
        }
        TopDocs[] topDocs = new TopFieldDocs[this.leafSlices.length];
        for (int i = 0; i < this.leafSlices.length; ++i) {
            try {
                topDocs[i] = (TopFieldDocs)((Future)topDocsFutures.get(i)).get();
                continue;
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return (TopFieldDocs)TopDocs.merge(sort, nDocs, topDocs);
    }

    protected TopFieldDocs search(List<LeafReaderContext> leaves, Weight weight, FieldDoc after, int nDocs, Sort sort, boolean fillFields, boolean doDocScores, boolean doMaxScore) throws IOException {
        int limit = this.reader.maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        nDocs = Math.min(nDocs, limit);
        TopFieldCollector collector = TopFieldCollector.create(sort, nDocs, after, fillFields, doDocScores, doMaxScore);
        this.search(leaves, weight, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(ctx);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            BulkScorer scorer = weight.bulkScorer(ctx, ctx.reader().getLiveDocs());
            if (scorer == null) continue;
            try {
                scorer.score(leafCollector);
            }
            catch (CollectionTerminatedException e) {}
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.explain(this.createNormalizedWeight(query), doc);
    }

    protected Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.leafContexts);
        LeafReaderContext ctx = this.leafContexts.get(n);
        int deBasedDoc = doc - ctx.docBase;
        return weight.explain(ctx, deBasedDoc);
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        query = this.rewrite(query);
        Weight weight = query.createWeight(this);
        float v = weight.getValueForNormalization();
        float norm = this.getSimilarity().queryNorm(v);
        if (Float.isInfinite(norm) || Float.isNaN(norm)) {
            norm = 1.0f;
        }
        weight.normalize(norm, 1.0f);
        return weight;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + "; executor=" + this.executor + ")";
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        return new TermStatistics(term.bytes(), context.docFreq(), context.totalTermFreq());
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        long sumDocFreq;
        long sumTotalTermFreq;
        int docCount;
        assert (field != null);
        Terms terms = MultiFields.getTerms(this.reader, field);
        if (terms == null) {
            docCount = 0;
            sumTotalTermFreq = 0L;
            sumDocFreq = 0L;
        } else {
            docCount = terms.getDocCount();
            sumTotalTermFreq = terms.getSumTotalTermFreq();
            sumDocFreq = terms.getSumDocFreq();
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    public static class LeafSlice {
        final LeafReaderContext[] leaves;

        public LeafSlice(LeafReaderContext ... leaves) {
            this.leaves = leaves;
        }
    }

    private static final class SearcherCallableWithSort
    implements Callable<TopFieldDocs> {
        private final IndexSearcher searcher;
        private final Weight weight;
        private final int nDocs;
        private final Sort sort;
        private final LeafSlice slice;
        private final FieldDoc after;
        private final boolean doDocScores;
        private final boolean doMaxScore;

        public SearcherCallableWithSort(IndexSearcher searcher, LeafSlice slice, Weight weight, FieldDoc after, int nDocs, Sort sort, boolean doDocScores, boolean doMaxScore) {
            this.searcher = searcher;
            this.weight = weight;
            this.nDocs = nDocs;
            this.sort = sort;
            this.slice = slice;
            this.after = after;
            this.doDocScores = doDocScores;
            this.doMaxScore = doMaxScore;
        }

        @Override
        public TopFieldDocs call() throws IOException {
            assert (this.slice.leaves.length == 1);
            return this.searcher.search(Arrays.asList(this.slice.leaves), this.weight, this.after, this.nDocs, this.sort, true, this.doDocScores, this.doMaxScore);
        }
    }

    private static final class SearcherCallableNoSort
    implements Callable<TopDocs> {
        private final IndexSearcher searcher;
        private final Weight weight;
        private final ScoreDoc after;
        private final int nDocs;
        private final LeafSlice slice;

        public SearcherCallableNoSort(IndexSearcher searcher, LeafSlice slice, Weight weight, ScoreDoc after, int nDocs) {
            this.searcher = searcher;
            this.weight = weight;
            this.after = after;
            this.nDocs = nDocs;
            this.slice = slice;
        }

        @Override
        public TopDocs call() throws IOException {
            return this.searcher.search(Arrays.asList(this.slice.leaves), this.weight, this.after, this.nDocs);
        }
    }
}

