/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EncodingParameter;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.parser.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.parser.GapLabeler;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.parser.lang.es.AncoraSpanishHeadRules;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserTrainerTool
extends AbstractTrainerTool<Parse, TrainerToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(ParserTrainerTool.class);

    public ParserTrainerTool() {
        super(Parse.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Trains the learnable parser";
    }

    static Dictionary buildDictionary(ObjectStream<Parse> parseSamples, HeadRules headRules, int cutoff) {
        Dictionary mdict;
        logger.info("Building dictionary ...");
        try {
            mdict = opennlp.tools.parser.chunking.Parser.buildDictionary(parseSamples, headRules, cutoff);
        }
        catch (IOException e) {
            logger.error("Error while building dictionary.", e);
            mdict = null;
        }
        logger.info("done");
        return mdict;
    }

    static ParserType parseParserType(String typeAsString) {
        ParserType type = null;
        if (typeAsString != null && typeAsString.length() > 0 && (type = ParserType.parse(typeAsString)) == null) {
            throw new TerminateToolException(1, "ParserType training parameter '" + typeAsString + "' is invalid!");
        }
        return type;
    }

    static HeadRules createHeadRules(TrainerToolParams params) throws IOException {
        ArtifactSerializer<GapLabeler> headRulesSerializer = params.getHeadRulesSerializerImpl() != null ? ExtensionLoader.instantiateExtension(ArtifactSerializer.class, params.getHeadRulesSerializerImpl()) : ("en".equals(params.getLang()) || "eng".equals(params.getLang()) ? new HeadRules.HeadRulesSerializer() : ("es".equals(params.getLang()) || "spa".equals(params.getLang()) ? new AncoraSpanishHeadRules.HeadRulesSerializer() : new HeadRules.HeadRulesSerializer()));
        Object headRulesObject = headRulesSerializer.create(new FileInputStream(params.getHeadRules()));
        if (headRulesObject instanceof HeadRules) {
            return (HeadRules)headRulesObject;
        }
        throw new TerminateToolException(-1, "HeadRules Artifact Serializer must create an object of type HeadRules!");
    }

    @Override
    public void run(String format, String[] args2) {
        ParserModel model;
        File modelOutFile;
        block19: {
            super.run(format, args2);
            this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
            if (this.mlParams != null) {
                if (!TrainerFactory.isValid(this.mlParams.getParameters("build"))) {
                    throw new TerminateToolException(1, "Build training parameters are invalid!");
                }
                if (!TrainerFactory.isValid(this.mlParams.getParameters("check"))) {
                    throw new TerminateToolException(1, "Check training parameters are invalid!");
                }
                if (!TrainerFactory.isValid(this.mlParams.getParameters("attach"))) {
                    throw new TerminateToolException(1, "Attach training parameters are invalid!");
                }
                if (!TrainerFactory.isValid(this.mlParams.getParameters("tagger"))) {
                    throw new TerminateToolException(1, "Tagger training parameters are invalid!");
                }
                if (!TrainerFactory.isValid(this.mlParams.getParameters("chunker"))) {
                    throw new TerminateToolException(1, "Chunker training parameters are invalid!");
                }
            }
            if (this.mlParams == null) {
                this.mlParams = ModelUtil.createDefaultTrainingParameters();
            }
            modelOutFile = ((TrainerToolParams)this.params).getModel();
            CmdLineUtil.checkOutputFile("parser model", modelOutFile);
            try {
                HeadRules rules = ParserTrainerTool.createHeadRules((TrainerToolParams)this.params);
                ParserType type = ParserTrainerTool.parseParserType(((TrainerToolParams)this.params).getParserType());
                if (((TrainerToolParams)this.params).getFun().booleanValue()) {
                    Parse.useFunctionTags(true);
                }
                if (ParserType.CHUNKING.equals((Object)type)) {
                    model = opennlp.tools.parser.chunking.Parser.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, rules, this.mlParams);
                    break block19;
                }
                if (ParserType.TREEINSERT.equals((Object)type)) {
                    model = Parser.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, rules, this.mlParams);
                    break block19;
                }
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw this.createTerminationIOException(e);
            }
            finally {
                try {
                    this.sampleStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        CmdLineUtil.writeModel("parser", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams,
    EncodingParameter {
    }
}

