/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class AnyTypeToStringConverterCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        ExpressionCompiler.visitAnnotation(compiler, "AnyTypeToStringConverter-Item");
        this.compileToPrimitive(compiler, expression, CharSequence.class, OnEmpty.RETURN_NULL);
        if (Cardinality.allowsZero(expression.getCardinality())) {
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            LabelInfo end = methodInfo.newLabel("endAnyTypeToItem");
            ga.dup();
            ga.ifNull(end.label());
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
            methodInfo.placeLabel(end);
        } else {
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        compiler.compileToItem(base);
        ExpressionCompiler.visitAnnotation(compiler, "AnyTypeToStringConverter-Primitive");
        if (allowsEmpty) {
            LabelInfo end = methodInfo.newLabel("endAnyTypeToStr");
            LabelInfo notNull = methodInfo.newLabel("notNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            onEmpty.generate(ga);
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
            this.generateNonNullCode(requiredClass, ga);
            methodInfo.placeLabel(end);
        } else {
            this.generateNonNullCode(requiredClass, ga);
        }
    }

    private void generateNonNullCode(Class requiredClass, Generator ga) {
        ga.checkClass(AtomicValue.class);
        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
        }
    }
}

